/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.search;

import java.util.ArrayList;
import org.eclipse.osee.executor.admin.CancellableCallable;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.framework.jdk.core.type.ResultSets;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.core.ds.QueryData;
import org.eclipse.osee.orcs.core.internal.search.TransactionCallableQueryFactory;
import org.eclipse.osee.orcs.core.internal.search.TransactionCriteriaFactory;
import org.eclipse.osee.orcs.core.internal.search.TxQueryBuilderImpl;
import org.eclipse.osee.orcs.data.TransactionReadable;
import org.eclipse.osee.orcs.search.TransactionQuery;

public class TransactionQueryImpl
extends TxQueryBuilderImpl<TransactionQuery>
implements TransactionQuery {
    private final TransactionCallableQueryFactory queryFactory;
    private final OrcsSession session;

    public TransactionQueryImpl(TransactionCallableQueryFactory queryFactory, TransactionCriteriaFactory criteriaFactory, OrcsSession session, QueryData queryData) {
        super(criteriaFactory, queryData);
        this.queryFactory = queryFactory;
        this.session = session;
    }

    public ResultSet<TransactionReadable> getResults() throws OseeCoreException {
        try {
            return (ResultSet)this.createSearch().call();
        }
        catch (Exception ex) {
            throw OseeCoreException.wrap((Throwable)ex);
        }
    }

    public ResultSet<TransactionToken> getTokens() {
        ArrayList<TransactionReadable> tokens = new ArrayList<TransactionReadable>();
        for (TransactionReadable tx : this.getResults()) {
            tokens.add(tx);
        }
        return ResultSets.newResultSet(tokens);
    }

    public ResultSet<Long> getResultsAsIds() throws OseeCoreException {
        try {
            return (ResultSet)this.createSearchResultsAsIds().call();
        }
        catch (Exception ex) {
            throw OseeCoreException.wrap((Throwable)ex);
        }
    }

    public int getCount() throws OseeCoreException {
        try {
            return (Integer)this.createCount().call();
        }
        catch (Exception ex) {
            throw OseeCoreException.wrap((Throwable)ex);
        }
    }

    public CancellableCallable<Integer> createCount() throws OseeCoreException {
        return this.queryFactory.createTransactionCount(this.session, this.buildAndCopy());
    }

    public CancellableCallable<ResultSet<TransactionReadable>> createSearch() throws OseeCoreException {
        return this.queryFactory.createTransactionSearch(this.session, this.buildAndCopy());
    }

    public CancellableCallable<ResultSet<Long>> createSearchResultsAsIds() throws OseeCoreException {
        return this.queryFactory.createTransactionAsIdSearch(this.session, this.buildAndCopy());
    }
}

