/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.search;

import com.google.common.collect.Lists;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.osee.executor.admin.CancellableCallable;
import org.eclipse.osee.framework.core.enums.LoadLevel;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.framework.jdk.core.type.ResultSets;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.core.ds.LoadDataHandlerAdapter;
import org.eclipse.osee.orcs.core.ds.OptionsUtil;
import org.eclipse.osee.orcs.core.ds.QueryCollector;
import org.eclipse.osee.orcs.core.ds.QueryData;
import org.eclipse.osee.orcs.core.ds.QueryEngine;
import org.eclipse.osee.orcs.core.ds.TxOrcsData;
import org.eclipse.osee.orcs.data.TransactionReadable;

public class TransactionCallableQueryFactory {
    private final Log logger;
    private final QueryEngine queryEngine;
    private final QueryCollector collector;

    public TransactionCallableQueryFactory(Log logger, QueryEngine queryEngine, QueryCollector collector) {
        this.logger = logger;
        this.queryEngine = queryEngine;
        this.collector = collector;
    }

    public CancellableCallable<Integer> createTransactionCount(OrcsSession session, QueryData queryData) {
        return new AbstractSearchCallable<Integer>(this, session, queryData){

            @Override
            protected Integer innerCall() throws Exception {
                Integer results = (Integer)queryEngine.createTxCount(this.getSession(), this.getQueryData()).call();
                this.setItemsFound(results);
                return results;
            }
        };
    }

    public CancellableCallable<ResultSet<TransactionReadable>> createTransactionSearch(OrcsSession session, QueryData queryData) {
        return new AbstractSearchCallable<ResultSet<TransactionReadable>>(this, session, queryData){

            @Override
            protected ResultSet<TransactionReadable> innerCall() throws Exception {
                TransactionBuilder<TransactionReadable> handler = new TransactionBuilder<TransactionReadable>(this){

                    @Override
                    public TransactionReadable create(TxOrcsData data) {
                        return data;
                    }
                };
                OptionsUtil.setLoadLevel(this.getQueryData().getOptions(), LoadLevel.ALL);
                queryEngine.createTxQuery(this.getSession(), this.getQueryData(), handler).call();
                ResultSet results = handler.getTransactions();
                this.setItemsFound(results.size());
                return results;
            }
        };
    }

    public CancellableCallable<ResultSet<Long>> createTransactionAsIdSearch(OrcsSession session, QueryData queryData) {
        return new AbstractSearchCallable<ResultSet<Long>>(this, session, queryData){

            @Override
            protected ResultSet<Long> innerCall() throws Exception {
                final LinkedHashSet txs = new LinkedHashSet();
                LoadDataHandlerAdapter handler = new LoadDataHandlerAdapter(){

                    @Override
                    public void onData(TxOrcsData data) {
                        txs.add(data.getId());
                    }
                };
                OptionsUtil.setLoadLevel(this.getQueryData().getOptions(), LoadLevel.ALL);
                queryEngine.createTxQuery(this.getSession(), this.getQueryData(), handler).call();
                this.setItemsFound(txs.size());
                return ResultSets.newResultSet(txs);
            }
        };
    }

    private abstract class AbstractSearchCallable<T>
    extends CancellableCallable<T> {
        private final OrcsSession session;
        private final QueryData queryData;
        private int itemsFound = 0;

        public AbstractSearchCallable(OrcsSession session, QueryData queryData) {
            this.session = session;
            this.queryData = queryData;
        }

        protected OrcsSession getSession() {
            return this.session;
        }

        protected QueryData getQueryData() {
            return this.queryData;
        }

        protected void setItemsFound(int itemsFound) {
            this.itemsFound = itemsFound;
        }

        public final T call() throws Exception {
            long startTime;
            long endTime = startTime = System.currentTimeMillis();
            T result = null;
            try {
                if (TransactionCallableQueryFactory.this.logger.isTraceEnabled()) {
                    TransactionCallableQueryFactory.this.logger.trace("%s [start] - [%s]", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), this.queryData});
                }
                result = this.innerCall();
            }
            finally {
                endTime = System.currentTimeMillis() - startTime;
            }
            if (result != null) {
                this.notifyStats(endTime);
            }
            if (TransactionCallableQueryFactory.this.logger.isTraceEnabled()) {
                TransactionCallableQueryFactory.this.logger.trace("%s [%s] - completed [%s]", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), Lib.asTimeString((long)endTime), this.queryData});
            }
            return result;
        }

        private void notifyStats(long processingTime) {
            if (TransactionCallableQueryFactory.this.collector != null) {
                try {
                    TransactionCallableQueryFactory.this.collector.collect(this.session, this.itemsFound, processingTime, this.queryData);
                }
                catch (Exception ex) {
                    TransactionCallableQueryFactory.this.logger.error((Throwable)ex, "Error reporting search to search collector\n%s", new Object[]{this.queryData});
                }
            }
        }

        protected abstract T innerCall() throws Exception;
    }

    private abstract class TransactionBuilder<T>
    extends LoadDataHandlerAdapter {
        private Map<Long, T> dataMap;
        private LinkedList<T> results;

        private TransactionBuilder() {
        }

        @Override
        public void onLoadStart() throws OseeCoreException {
            super.onLoadStart();
            this.dataMap = new LinkedHashMap<Long, T>();
        }

        @Override
        public void onLoadEnd() throws OseeCoreException {
            super.onLoadEnd();
            this.results = Lists.newLinkedList(this.dataMap.values());
            this.dataMap.clear();
        }

        @Override
        public void onData(TxOrcsData data) throws OseeCoreException {
            Long key = data.getId();
            T branch = this.dataMap.get(key);
            if (branch == null) {
                branch = this.create(data);
                this.dataMap.put(key, branch);
            }
        }

        public ResultSet<T> getTransactions() {
            return ResultSets.newResultSet(this.results);
        }

        public abstract T create(TxOrcsData var1) throws OseeCoreException;
    }
}

