/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.search;

import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.orcs.core.ds.QueryData;
import org.eclipse.osee.orcs.statistics.QueryStatistics;

public class QueryStatisticsImpl
implements Cloneable,
QueryStatistics {
    public static final QueryStatisticsImpl EMPTY_STATS = new EmptyStats();
    private static final String EMPTY_STRING = "";
    private long averageProcessingTime;
    private int totalProcessed;
    private long totalProcessingTime;
    private long longestProcessingTime;
    private String longestQuery;

    public QueryStatisticsImpl() {
        this.clear();
    }

    public void clear() {
        this.averageProcessingTime = 0L;
        this.totalProcessed = 0;
        this.totalProcessingTime = 0L;
        this.longestProcessingTime = 0L;
        this.longestQuery = EMPTY_STRING;
    }

    public long getAverageSearchTime() {
        return this.averageProcessingTime;
    }

    public int getTotalSearches() {
        return this.totalProcessed;
    }

    public long getLongestSearchTime() {
        return this.longestProcessingTime;
    }

    public String getLongestSearch() {
        return this.longestQuery;
    }

    public void addEntry(QueryData query, int found, long processingTime) throws OseeCoreException {
        Conditions.checkNotNull((Object)query, (String)"query");
        ++this.totalProcessed;
        this.totalProcessingTime += processingTime;
        this.averageProcessingTime = this.totalProcessingTime / (long)this.totalProcessed;
        if (processingTime > this.longestProcessingTime) {
            this.longestProcessingTime = processingTime;
            this.longestQuery = this.toString(found, processingTime, query);
        }
    }

    private String toString(int found, long processingTime, QueryData data) {
        StringBuilder builder = new StringBuilder();
        builder.append("Query:\n");
        builder.append("\tFound: [");
        builder.append(found);
        builder.append(" item(s) in ");
        builder.append(Lib.asTimeString((long)processingTime));
        builder.append("]\n");
        builder.append("\tDetails:\n\t\t");
        builder.append(data.getOptions());
        builder.append("\n\t\t");
        builder.append(data.getCriteriaSets());
        builder.append("\n");
        return builder.toString();
    }

    public QueryStatisticsImpl clone() {
        QueryStatisticsImpl other = new QueryStatisticsImpl();
        other.averageProcessingTime = this.averageProcessingTime;
        other.totalProcessed = this.totalProcessed;
        other.totalProcessingTime = this.totalProcessingTime;
        other.longestProcessingTime = this.longestProcessingTime;
        other.longestQuery = this.longestQuery;
        return other;
    }

    private static final class EmptyStats
    extends QueryStatisticsImpl {
        private EmptyStats() {
        }

        @Override
        public void addEntry(QueryData query, int found, long processingTime) {
            throw new UnsupportedOperationException();
        }
    }
}

