/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.search;

import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.core.ds.QueryEngine;
import org.eclipse.osee.orcs.core.internal.HasStatistics;
import org.eclipse.osee.orcs.core.internal.graph.GraphBuilderFactory;
import org.eclipse.osee.orcs.core.internal.graph.GraphProvider;
import org.eclipse.osee.orcs.core.internal.proxy.ExternalArtifactManager;
import org.eclipse.osee.orcs.core.internal.search.BranchCallableQueryFactory;
import org.eclipse.osee.orcs.core.internal.search.BranchCriteriaFactory;
import org.eclipse.osee.orcs.core.internal.search.CallableQueryFactory;
import org.eclipse.osee.orcs.core.internal.search.CriteriaFactory;
import org.eclipse.osee.orcs.core.internal.search.QueryFactoryImpl;
import org.eclipse.osee.orcs.core.internal.search.QueryStatisticsImpl;
import org.eclipse.osee.orcs.core.internal.search.QueryStatsCollectorImpl;
import org.eclipse.osee.orcs.core.internal.search.TransactionCallableQueryFactory;
import org.eclipse.osee.orcs.core.internal.search.TransactionCriteriaFactory;
import org.eclipse.osee.orcs.data.ArtifactTypes;
import org.eclipse.osee.orcs.data.AttributeTypes;
import org.eclipse.osee.orcs.search.QueryFactory;
import org.eclipse.osee.orcs.search.TupleQuery;
import org.eclipse.osee.orcs.statistics.QueryStatistics;

public class QueryModule
implements HasStatistics<QueryStatistics> {
    private final QueryStatisticsImpl statistics = new QueryStatisticsImpl();
    private final CriteriaFactory criteriaFctry;
    private final CallableQueryFactory artQueryFactory;
    private final BranchCallableQueryFactory branchQueryFactory;
    private final BranchCriteriaFactory branchCriteriaFactory;
    private final TransactionCallableQueryFactory txQueryFactory;
    private final TransactionCriteriaFactory txCriteriaFactory;
    private final TupleQuery tupleQuery;

    public QueryModule(Log logger, QueryEngine queryEngine, GraphBuilderFactory builderFactory, GraphProvider provider, ArtifactTypes artifactTypeCache, AttributeTypes attributeTypeCache, ExternalArtifactManager proxyManager) {
        QueryStatsCollectorImpl queryStatsCollector = new QueryStatsCollectorImpl(this.statistics);
        this.criteriaFctry = new CriteriaFactory(artifactTypeCache, attributeTypeCache);
        this.artQueryFactory = new CallableQueryFactory(logger, queryEngine, queryStatsCollector, builderFactory, provider, proxyManager);
        this.branchCriteriaFactory = new BranchCriteriaFactory();
        this.branchQueryFactory = new BranchCallableQueryFactory(logger, queryEngine, queryStatsCollector);
        this.txQueryFactory = new TransactionCallableQueryFactory(logger, queryEngine, queryStatsCollector);
        this.txCriteriaFactory = new TransactionCriteriaFactory();
        this.tupleQuery = queryEngine.createTupleQuery();
    }

    public QueryFactory createQueryFactory(OrcsSession session) {
        return new QueryFactoryImpl(session, this.criteriaFctry, this.artQueryFactory, this.branchCriteriaFactory, this.branchQueryFactory, this.txQueryFactory, this.txCriteriaFactory, this.tupleQuery);
    }

    @Override
    public QueryStatistics getStatistics(OrcsSession session) {
        return this.statistics.clone();
    }

    @Override
    public void clearStatistics(OrcsSession session) {
        this.statistics.clear();
    }

    public static interface QueryModuleProvider {
        public QueryFactory getQueryFactory(OrcsSession var1);
    }
}

