/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.search;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.IArtifactType;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.core.ds.CriteriaSet;
import org.eclipse.osee.orcs.core.ds.Options;
import org.eclipse.osee.orcs.core.ds.OptionsUtil;
import org.eclipse.osee.orcs.core.ds.QueryData;
import org.eclipse.osee.orcs.core.ds.criteria.CriteriaBranch;
import org.eclipse.osee.orcs.core.internal.search.ApplicabilityQueryImpl;
import org.eclipse.osee.orcs.core.internal.search.BranchCallableQueryFactory;
import org.eclipse.osee.orcs.core.internal.search.BranchCriteriaFactory;
import org.eclipse.osee.orcs.core.internal.search.BranchQueryImpl;
import org.eclipse.osee.orcs.core.internal.search.CallableQueryFactory;
import org.eclipse.osee.orcs.core.internal.search.CriteriaFactory;
import org.eclipse.osee.orcs.core.internal.search.QueryBuilderImpl;
import org.eclipse.osee.orcs.core.internal.search.TransactionCallableQueryFactory;
import org.eclipse.osee.orcs.core.internal.search.TransactionCriteriaFactory;
import org.eclipse.osee.orcs.core.internal.search.TransactionQueryImpl;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.search.ApplicabilityQuery;
import org.eclipse.osee.orcs.search.BranchQuery;
import org.eclipse.osee.orcs.search.QueryBuilder;
import org.eclipse.osee.orcs.search.QueryFactory;
import org.eclipse.osee.orcs.search.TransactionQuery;
import org.eclipse.osee.orcs.search.TupleQuery;

public class QueryFactoryImpl
implements QueryFactory {
    private final OrcsSession context;
    private final CriteriaFactory criteriaFctry;
    private final CallableQueryFactory queryFctry;
    private final BranchCriteriaFactory branchCriteriaFactory;
    private final BranchCallableQueryFactory branchQueryFactory;
    private final TransactionCallableQueryFactory txQueryFactory;
    private final TransactionCriteriaFactory txCriteriaFactory;
    private final TupleQuery tupleQuery;

    public QueryFactoryImpl(OrcsSession context, CriteriaFactory criteriaFctry, CallableQueryFactory queryFctry, BranchCriteriaFactory branchCriteriaFactory, BranchCallableQueryFactory branchQueryFactory, TransactionCallableQueryFactory txQueryFactory, TransactionCriteriaFactory txCriteriaFactory, TupleQuery tupleQuery) {
        this.context = context;
        this.criteriaFctry = criteriaFctry;
        this.queryFctry = queryFctry;
        this.branchCriteriaFactory = branchCriteriaFactory;
        this.branchQueryFactory = branchQueryFactory;
        this.txQueryFactory = txQueryFactory;
        this.txCriteriaFactory = txCriteriaFactory;
        this.tupleQuery = tupleQuery;
    }

    private QueryBuilder createBuilder(BranchId branchId) {
        Options options = OptionsUtil.createOptions();
        CriteriaSet criteriaSet = new CriteriaSet();
        if (branchId != null) {
            criteriaSet.add(new CriteriaBranch(branchId));
        }
        QueryData queryData = new QueryData(criteriaSet, options);
        QueryBuilderImpl builder = new QueryBuilderImpl(this.queryFctry, this.criteriaFctry, this.context, queryData);
        return builder;
    }

    public BranchQuery branchQuery() {
        Options options = OptionsUtil.createOptions();
        CriteriaSet criteriaSet = new CriteriaSet();
        QueryData queryData = new QueryData(criteriaSet, options);
        BranchQueryImpl query = new BranchQueryImpl(this.branchQueryFactory, this.branchCriteriaFactory, this.context, queryData);
        return query;
    }

    public QueryBuilder fromBranch(BranchId branch) throws OseeCoreException {
        return this.createBuilder(branch);
    }

    public QueryBuilder fromArtifacts(Collection<? extends ArtifactReadable> artifacts) throws OseeCoreException {
        Conditions.checkNotNullOrEmpty(artifacts, (String)"artifacts");
        ArtifactReadable artifact = artifacts.iterator().next();
        HashSet<String> guids = new HashSet<String>();
        for (ArtifactReadable artifactReadable : artifacts) {
            guids.add((String)artifactReadable.getGuid());
        }
        return (QueryBuilder)this.fromBranch(artifact.getBranch()).andGuids(guids);
    }

    public QueryBuilder fromArtifactTypeAllBranches(IArtifactType artifactType) throws OseeCoreException {
        QueryBuilder builder = this.createBuilder(null);
        builder.andIsOfType(new ArtifactTypeId[]{artifactType});
        return builder;
    }

    public TransactionQuery transactionQuery() {
        Options options = OptionsUtil.createOptions();
        CriteriaSet criteriaSet = new CriteriaSet();
        QueryData queryData = new QueryData(criteriaSet, options);
        TransactionQueryImpl query = new TransactionQueryImpl(this.txQueryFactory, this.txCriteriaFactory, this.context, queryData);
        return query;
    }

    public TupleQuery tupleQuery() {
        return this.tupleQuery;
    }

    public ApplicabilityQuery applicabilityQuery() {
        return new ApplicabilityQueryImpl(this.tupleQuery);
    }
}

