/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.search;

import org.eclipse.osee.executor.admin.CancellableCallable;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.core.ds.QueryData;
import org.eclipse.osee.orcs.core.internal.search.ArtifactQueryBuilderImpl;
import org.eclipse.osee.orcs.core.internal.search.CallableQueryFactory;
import org.eclipse.osee.orcs.core.internal.search.CriteriaFactory;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.data.AttributeReadable;
import org.eclipse.osee.orcs.search.Match;
import org.eclipse.osee.orcs.search.QueryBuilder;

public class QueryBuilderImpl
extends ArtifactQueryBuilderImpl<QueryBuilder>
implements QueryBuilder {
    private final CallableQueryFactory queryFactory;
    private final OrcsSession session;

    public QueryBuilderImpl(CallableQueryFactory queryFactory, CriteriaFactory criteriaFactory, OrcsSession session, QueryData queryData) {
        super(criteriaFactory, queryData);
        this.queryFactory = queryFactory;
        this.session = session;
    }

    public ResultSet<ArtifactReadable> getResults() throws OseeCoreException {
        try {
            return (ResultSet)this.createSearch().call();
        }
        catch (Exception ex) {
            throw OseeCoreException.wrap((Throwable)ex);
        }
    }

    public ResultSet<Match<ArtifactReadable, AttributeReadable<?>>> getMatches() throws OseeCoreException {
        try {
            return (ResultSet)this.createSearchWithMatches().call();
        }
        catch (Exception ex) {
            throw OseeCoreException.wrap((Throwable)ex);
        }
    }

    public int getCount() throws OseeCoreException {
        try {
            return (Integer)this.createCount().call();
        }
        catch (Exception ex) {
            throw OseeCoreException.wrap((Throwable)ex);
        }
    }

    public ResultSet<? extends ArtifactId> getResultsAsLocalIds() throws OseeCoreException {
        try {
            return (ResultSet)this.createSearchResultsAsLocalIds().call();
        }
        catch (Exception ex) {
            throw OseeCoreException.wrap((Throwable)ex);
        }
    }

    public CancellableCallable<ResultSet<ArtifactReadable>> createSearch() throws OseeCoreException {
        return this.queryFactory.createSearch(this.session, this.buildAndCopy());
    }

    public CancellableCallable<ResultSet<Match<ArtifactReadable, AttributeReadable<?>>>> createSearchWithMatches() throws OseeCoreException {
        return this.queryFactory.createSearchWithMatches(this.session, this.buildAndCopy());
    }

    public CancellableCallable<ResultSet<? extends ArtifactId>> createSearchResultsAsLocalIds() throws OseeCoreException {
        return this.queryFactory.createLocalIdSearch(this.session, this.buildAndCopy());
    }

    public CancellableCallable<Integer> createCount() throws OseeCoreException {
        return this.queryFactory.createCount(this.session, this.buildAndCopy());
    }
}

