/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.search;

import com.google.common.collect.Iterables;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.osee.executor.admin.CancellableCallable;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.enums.LoadLevel;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.framework.jdk.core.type.ResultSets;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.core.ds.ArtifactData;
import org.eclipse.osee.orcs.core.ds.LoadDataHandlerAdapter;
import org.eclipse.osee.orcs.core.ds.OptionsUtil;
import org.eclipse.osee.orcs.core.ds.QueryCollector;
import org.eclipse.osee.orcs.core.ds.QueryData;
import org.eclipse.osee.orcs.core.ds.QueryEngine;
import org.eclipse.osee.orcs.core.internal.artifact.Artifact;
import org.eclipse.osee.orcs.core.internal.graph.GraphBuilder;
import org.eclipse.osee.orcs.core.internal.graph.GraphBuilderFactory;
import org.eclipse.osee.orcs.core.internal.graph.GraphProvider;
import org.eclipse.osee.orcs.core.internal.proxy.ExternalArtifactManager;
import org.eclipse.osee.orcs.core.internal.search.ArtifactMatchDataHandler;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.data.AttributeReadable;
import org.eclipse.osee.orcs.search.Match;

public class CallableQueryFactory {
    private final Log logger;
    private final QueryEngine queryEngine;
    private final QueryCollector collector;
    private final GraphBuilderFactory builderFactory;
    private final GraphProvider provider;
    private final ExternalArtifactManager proxyManager;

    public CallableQueryFactory(Log logger, QueryEngine queryEngine, QueryCollector collector, GraphBuilderFactory builderFactory, GraphProvider provider, ExternalArtifactManager proxyManager) {
        this.logger = logger;
        this.queryEngine = queryEngine;
        this.collector = collector;
        this.builderFactory = builderFactory;
        this.provider = provider;
        this.proxyManager = proxyManager;
    }

    public CancellableCallable<Integer> createCount(OrcsSession session, QueryData queryData) {
        return new AbstractSearchCallable<Integer>(this, session, queryData){

            @Override
            protected Integer innerCall() throws Exception {
                Integer results = (Integer)queryEngine.createArtifactCount(this.getSession(), this.getQueryData()).call();
                this.setItemsFound(results);
                return results;
            }
        };
    }

    public CancellableCallable<ResultSet<? extends ArtifactId>> createLocalIdSearch(OrcsSession session, QueryData queryData) {
        return new AbstractSearchCallable<ResultSet<? extends ArtifactId>>(this, session, queryData){

            @Override
            protected ResultSet<? extends ArtifactId> innerCall() throws Exception {
                final LinkedList results = new LinkedList();
                LoadDataHandlerAdapter handler = new LoadDataHandlerAdapter(){

                    @Override
                    public void onData(ArtifactData data) {
                        results.add(data);
                    }
                };
                OptionsUtil.setLoadLevel(this.getQueryData().getOptions(), LoadLevel.ARTIFACT_AND_ATTRIBUTE_DATA);
                queryEngine.createArtifactQuery(this.getSession(), this.getQueryData(), handler).call();
                this.setItemsFound(results.size());
                return ResultSets.newResultSet(results);
            }
        };
    }

    public CancellableCallable<ResultSet<ArtifactReadable>> createSearch(OrcsSession session, QueryData queryData) {
        return new AbstractSearchCallable<ResultSet<ArtifactReadable>>(this, session, queryData){

            @Override
            protected ResultSet<ArtifactReadable> innerCall() throws Exception {
                GraphBuilder handler = builderFactory.createGraphBuilder(provider);
                OptionsUtil.setLoadLevel(this.getQueryData().getOptions(), LoadLevel.ALL);
                queryEngine.createArtifactQuery(this.getSession(), this.getQueryData(), handler).call();
                Iterable<Artifact> results = handler.getArtifacts();
                this.setItemsFound(Iterables.size(results));
                return proxyManager.asExternalArtifacts(this.getSession(), results);
            }
        };
    }

    public CancellableCallable<ResultSet<Match<ArtifactReadable, AttributeReadable<?>>>> createSearchWithMatches(OrcsSession session, QueryData queryData) {
        return new AbstractSearchCallable<ResultSet<Match<ArtifactReadable, AttributeReadable<?>>>>(this, session, queryData){

            @Override
            protected ResultSet<Match<ArtifactReadable, AttributeReadable<?>>> innerCall() throws Exception {
                GraphBuilder handler = builderFactory.createGraphBuilder(provider);
                ArtifactMatchDataHandler matchHandler = new ArtifactMatchDataHandler(this.getSession(), handler, proxyManager);
                OptionsUtil.setLoadLevel(this.getQueryData().getOptions(), LoadLevel.ALL);
                queryEngine.createArtifactQuery(this.getSession(), this.getQueryData(), matchHandler).call();
                List<Match<ArtifactReadable, AttributeReadable<?>>> results = matchHandler.getResults();
                this.setItemsFound(Iterables.size(results));
                return ResultSets.newResultSet(results);
            }
        };
    }

    private abstract class AbstractSearchCallable<T>
    extends CancellableCallable<T> {
        private final OrcsSession session;
        private final QueryData queryData;
        private int itemsFound = 0;

        public AbstractSearchCallable(OrcsSession session, QueryData queryData) {
            this.session = session;
            this.queryData = queryData;
        }

        protected OrcsSession getSession() {
            return this.session;
        }

        protected QueryData getQueryData() {
            return this.queryData;
        }

        protected void setItemsFound(int itemsFound) {
            this.itemsFound = itemsFound;
        }

        public final T call() throws Exception {
            long startTime;
            long endTime = startTime = System.currentTimeMillis();
            T result = null;
            try {
                if (CallableQueryFactory.this.logger.isTraceEnabled()) {
                    CallableQueryFactory.this.logger.trace("%s [start] - [%s]", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), this.queryData});
                }
                result = this.innerCall();
            }
            finally {
                endTime = System.currentTimeMillis() - startTime;
            }
            if (result != null) {
                this.notifyStats(endTime);
            }
            if (CallableQueryFactory.this.logger.isTraceEnabled()) {
                CallableQueryFactory.this.logger.trace("%s [%s] - completed [%s]", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), Lib.asTimeString((long)endTime), this.queryData});
            }
            return result;
        }

        private void notifyStats(long processingTime) {
            if (CallableQueryFactory.this.collector != null) {
                try {
                    CallableQueryFactory.this.collector.collect(this.session, this.itemsFound, processingTime, this.queryData);
                }
                catch (Exception ex) {
                    CallableQueryFactory.this.logger.error((Throwable)ex, "Error reporting search to search collector\n%s", new Object[]{this.queryData});
                }
            }
        }

        protected abstract T innerCall() throws Exception;
    }
}

