/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.search;

import org.eclipse.osee.executor.admin.CancellableCallable;
import org.eclipse.osee.framework.core.data.IOseeBranch;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.core.ds.QueryData;
import org.eclipse.osee.orcs.core.internal.search.BranchCallableQueryFactory;
import org.eclipse.osee.orcs.core.internal.search.BranchCriteriaFactory;
import org.eclipse.osee.orcs.core.internal.search.BranchQueryBuilderImpl;
import org.eclipse.osee.orcs.data.BranchReadable;
import org.eclipse.osee.orcs.search.BranchQuery;

public class BranchQueryImpl
extends BranchQueryBuilderImpl<BranchQuery>
implements BranchQuery {
    private final BranchCallableQueryFactory queryFactory;
    private final OrcsSession session;

    public BranchQueryImpl(BranchCallableQueryFactory queryFactory, BranchCriteriaFactory criteriaFactory, OrcsSession session, QueryData queryData) {
        super(criteriaFactory, queryData);
        this.queryFactory = queryFactory;
        this.session = session;
    }

    public ResultSet<BranchReadable> getResults() throws OseeCoreException {
        try {
            return (ResultSet)this.createSearch().call();
        }
        catch (Exception ex) {
            throw OseeCoreException.wrap((Throwable)ex);
        }
    }

    public ResultSet<IOseeBranch> getResultsAsId() throws OseeCoreException {
        try {
            return (ResultSet)this.createSearchResultsAsIds().call();
        }
        catch (Exception ex) {
            throw OseeCoreException.wrap((Throwable)ex);
        }
    }

    public int getCount() throws OseeCoreException {
        try {
            return (Integer)this.createCount().call();
        }
        catch (Exception ex) {
            throw OseeCoreException.wrap((Throwable)ex);
        }
    }

    public CancellableCallable<Integer> createCount() throws OseeCoreException {
        return this.queryFactory.createBranchCount(this.session, this.buildAndCopy());
    }

    public CancellableCallable<ResultSet<BranchReadable>> createSearch() throws OseeCoreException {
        return this.queryFactory.createBranchSearch(this.session, this.buildAndCopy());
    }

    public CancellableCallable<ResultSet<IOseeBranch>> createSearchResultsAsIds() throws OseeCoreException {
        return this.queryFactory.createBranchAsIdSearch(this.session, this.buildAndCopy());
    }
}

