/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.BranchArchivedState;
import org.eclipse.osee.framework.core.enums.BranchState;
import org.eclipse.osee.framework.core.enums.BranchType;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.orcs.core.ds.Criteria;
import org.eclipse.osee.orcs.core.ds.Options;
import org.eclipse.osee.orcs.core.ds.OptionsUtil;
import org.eclipse.osee.orcs.core.ds.QueryData;
import org.eclipse.osee.orcs.core.ds.criteria.CriteriaBranchIds;
import org.eclipse.osee.orcs.core.internal.search.BranchCriteriaFactory;
import org.eclipse.osee.orcs.search.BranchQueryBuilder;

public class BranchQueryBuilderImpl<T>
implements BranchQueryBuilder<T> {
    private final BranchCriteriaFactory criteriaFactory;
    private final QueryData queryData;
    private boolean includeArchived;

    public BranchQueryBuilderImpl(BranchCriteriaFactory criteriaFactory, QueryData queryData) {
        this.criteriaFactory = criteriaFactory;
        this.queryData = queryData;
        this.includeDeleted();
        this.includeArchived();
    }

    private QueryData getQueryData() {
        return this.queryData;
    }

    private Options getOptions() {
        return this.queryData.getOptions();
    }

    public T includeDeleted() {
        return this.includeDeleted(true);
    }

    public T excludeDeleted() {
        return this.includeDeleted(false);
    }

    public T includeDeleted(boolean enabled) {
        OptionsUtil.setIncludeDeletedBranches(this.getOptions(), enabled);
        return (T)this;
    }

    public boolean areDeletedIncluded() {
        return OptionsUtil.areDeletedBranchesIncluded(this.getOptions());
    }

    public T includeArchived() {
        return this.includeArchived(true);
    }

    public T includeArchived(boolean enabled) {
        this.includeArchived = enabled;
        return (T)this;
    }

    public T excludeArchived() {
        return this.includeArchived(false);
    }

    public boolean areArchivedIncluded() {
        return this.includeArchived;
    }

    public T andIds(Collection<? extends BranchId> branchIds) {
        return this.addAndCheck(this.getQueryData(), new CriteriaBranchIds(branchIds));
    }

    public T andId(BranchId branchId) {
        return this.addAndCheck(this.getQueryData(), new CriteriaBranchIds(branchId));
    }

    public T andIsOfType(BranchType ... branchType) throws OseeCoreException {
        Criteria criteria = this.criteriaFactory.createBranchTypeCriteria(Arrays.asList(branchType));
        return this.addAndCheck(this.getQueryData(), criteria);
    }

    public T andStateIs(BranchState ... branchState) throws OseeCoreException {
        Criteria criteria = this.criteriaFactory.createBranchStateCriteria(Arrays.asList(branchState));
        return this.addAndCheck(this.getQueryData(), criteria);
    }

    public T andNameEquals(String value) throws OseeCoreException {
        Criteria criteria = this.criteriaFactory.createBranchNameCriteria(value, false);
        return this.addAndCheck(this.getQueryData(), criteria);
    }

    public T andNamePattern(String pattern) throws OseeCoreException {
        Criteria criteria = this.criteriaFactory.createBranchNameCriteria(pattern, true);
        return this.addAndCheck(this.getQueryData(), criteria);
    }

    public T andIsChildOf(BranchId parent) throws OseeCoreException {
        Criteria criteria = this.criteriaFactory.createBranchChildOfCriteria(parent);
        return this.addAndCheck(this.getQueryData(), criteria);
    }

    public T andIsAncestorOf(BranchId child) throws OseeCoreException {
        Criteria criteria = this.criteriaFactory.createBranchAncestorOfCriteria(child);
        return this.addAndCheck(this.getQueryData(), criteria);
    }

    public T andIsMergeFor(BranchId source, BranchId destination) {
        Criteria criteria = this.criteriaFactory.createMergeForCriteria(source, destination);
        return this.addAndCheck(this.getQueryData(), criteria);
    }

    public T andAssociatedArtId(ArtifactId artId) {
        Criteria criteria = this.criteriaFactory.createAssociatedArtIdCriteria(artId);
        return this.addAndCheck(this.getQueryData(), criteria);
    }

    private T addAndCheck(QueryData queryData, Criteria criteria) throws OseeCoreException {
        criteria.checkValid(this.getOptions());
        queryData.addCriteria(criteria);
        return (T)this;
    }

    public QueryData buildAndCopy() {
        return this.build(true);
    }

    public QueryData build() {
        return this.build(false);
    }

    private QueryData build(boolean clone) {
        ArrayList<BranchArchivedState> states;
        QueryData queryData = clone ? this.getQueryData().clone() : this.getQueryData();
        List<Criteria> criterias = queryData.getAllCriteria();
        if (criterias.isEmpty()) {
            this.addAndCheck(queryData, this.criteriaFactory.createAllBranchesCriteria());
        }
        if (!this.areArchivedIncluded()) {
            states = Arrays.asList(BranchArchivedState.UNARCHIVED);
            this.addAndCheck(queryData, this.criteriaFactory.createBranchArchivedCriteria(states));
        }
        if (!this.areDeletedIncluded()) {
            states = new ArrayList();
            BranchState[] branchStateArray = BranchState.values();
            int n = branchStateArray.length;
            int n2 = 0;
            while (n2 < n) {
                BranchState state = branchStateArray[n2];
                if (state != BranchState.DELETE_IN_PROGRESS && state != BranchState.DELETED && state != BranchState.PURGE_IN_PROGRESS && state != BranchState.PURGED) {
                    states.add((BranchArchivedState)state);
                }
                ++n2;
            }
            this.addAndCheck(queryData, this.criteriaFactory.createBranchStateCriteria(states));
        }
        return queryData;
    }
}

