/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.search;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.osee.executor.admin.CancellableCallable;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.IOseeBranch;
import org.eclipse.osee.framework.core.enums.LoadLevel;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.framework.jdk.core.type.ResultSets;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.core.ds.BranchData;
import org.eclipse.osee.orcs.core.ds.LoadDataHandlerAdapter;
import org.eclipse.osee.orcs.core.ds.OptionsUtil;
import org.eclipse.osee.orcs.core.ds.QueryCollector;
import org.eclipse.osee.orcs.core.ds.QueryData;
import org.eclipse.osee.orcs.core.ds.QueryEngine;
import org.eclipse.osee.orcs.data.BranchReadable;

public class BranchCallableQueryFactory {
    private final Log logger;
    private final QueryEngine queryEngine;
    private final QueryCollector collector;

    public BranchCallableQueryFactory(Log logger, QueryEngine queryEngine, QueryCollector collector) {
        this.logger = logger;
        this.queryEngine = queryEngine;
        this.collector = collector;
    }

    public CancellableCallable<Integer> createBranchCount(OrcsSession session, QueryData queryData) {
        return new AbstractSearchCallable<Integer>(this, session, queryData){

            @Override
            protected Integer innerCall() throws Exception {
                Integer results = (Integer)queryEngine.createBranchCount(this.getSession(), this.getQueryData()).call();
                this.setItemsFound(results);
                return results;
            }
        };
    }

    public CancellableCallable<ResultSet<BranchReadable>> createBranchSearch(OrcsSession session, QueryData queryData) {
        return new AbstractSearchCallable<ResultSet<BranchReadable>>(this, session, queryData){

            @Override
            protected ResultSet<BranchReadable> innerCall() throws Exception {
                BranchBuilder<BranchReadable> handler = new BranchBuilder<BranchReadable>(this){

                    @Override
                    public BranchReadable createBranch(BranchData data) {
                        return (BranchReadable)data;
                    }
                };
                OptionsUtil.setLoadLevel(this.getQueryData().getOptions(), LoadLevel.ALL);
                queryEngine.createBranchQuery(this.getSession(), this.getQueryData(), handler).call();
                List results = handler.getBranches();
                this.setItemsFound(results.size());
                return ResultSets.newResultSet(results);
            }
        };
    }

    public CancellableCallable<ResultSet<IOseeBranch>> createBranchAsIdSearch(OrcsSession session, QueryData queryData) {
        return new AbstractSearchCallable<ResultSet<IOseeBranch>>(this, session, queryData){

            @Override
            protected ResultSet<IOseeBranch> innerCall() throws Exception {
                BranchBuilder<IOseeBranch> handler = new BranchBuilder<IOseeBranch>(this){

                    @Override
                    public IOseeBranch createBranch(BranchData data) {
                        return IOseeBranch.create((Long)data.getUuid(), (String)data.getName());
                    }
                };
                OptionsUtil.setLoadLevel(this.getQueryData().getOptions(), LoadLevel.ALL);
                queryEngine.createBranchQuery(this.getSession(), this.getQueryData(), handler).call();
                List results = handler.getBranches();
                this.setItemsFound(results.size());
                return ResultSets.newResultSet(results);
            }
        };
    }

    private abstract class AbstractSearchCallable<T>
    extends CancellableCallable<T> {
        private final OrcsSession session;
        private final QueryData queryData;
        private int itemsFound = 0;

        public AbstractSearchCallable(OrcsSession session, QueryData queryData) {
            this.session = session;
            this.queryData = queryData;
        }

        protected OrcsSession getSession() {
            return this.session;
        }

        protected QueryData getQueryData() {
            return this.queryData;
        }

        protected void setItemsFound(int itemsFound) {
            this.itemsFound = itemsFound;
        }

        public final T call() throws Exception {
            long startTime;
            long endTime = startTime = System.currentTimeMillis();
            T result = null;
            try {
                if (BranchCallableQueryFactory.this.logger.isTraceEnabled()) {
                    BranchCallableQueryFactory.this.logger.trace("%s [start] - [%s]", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), this.queryData});
                }
                result = this.innerCall();
            }
            finally {
                endTime = System.currentTimeMillis() - startTime;
            }
            if (result != null) {
                this.notifyStats(endTime);
            }
            if (BranchCallableQueryFactory.this.logger.isTraceEnabled()) {
                BranchCallableQueryFactory.this.logger.trace("%s [%s] - completed [%s]", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), Lib.asTimeString((long)endTime), this.queryData});
            }
            return result;
        }

        private void notifyStats(long processingTime) {
            if (BranchCallableQueryFactory.this.collector != null) {
                try {
                    BranchCallableQueryFactory.this.collector.collect(this.session, this.itemsFound, processingTime, this.queryData);
                }
                catch (Exception ex) {
                    BranchCallableQueryFactory.this.logger.error((Throwable)ex, "Error reporting search to search collector\n%s", new Object[]{this.queryData});
                }
            }
        }

        protected abstract T innerCall() throws Exception;
    }

    private abstract class BranchBuilder<T extends BranchId>
    extends LoadDataHandlerAdapter {
        private Map<Long, T> branchMap;
        private List<T> results;

        private BranchBuilder() {
        }

        @Override
        public void onLoadStart() throws OseeCoreException {
            super.onLoadStart();
            this.branchMap = new LinkedHashMap<Long, T>();
        }

        @Override
        public void onLoadEnd() throws OseeCoreException {
            super.onLoadEnd();
            this.results = new LinkedList<T>(this.branchMap.values());
            this.branchMap.clear();
        }

        @Override
        public void onData(BranchData data) throws OseeCoreException {
            Long key = data.getUuid();
            Object branch = (BranchId)this.branchMap.get(key);
            if (branch == null) {
                branch = this.createBranch(data);
                this.branchMap.put(key, branch);
            }
        }

        public List<T> getBranches() {
            return this.results;
        }

        public abstract T createBranch(BranchData var1) throws OseeCoreException;
    }
}

