/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.search;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.IRelationType;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.enums.CoreArtifactTokens;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.QueryOption;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.GUID;
import org.eclipse.osee.orcs.core.ds.Criteria;
import org.eclipse.osee.orcs.core.ds.Options;
import org.eclipse.osee.orcs.core.ds.OptionsUtil;
import org.eclipse.osee.orcs.core.ds.QueryData;
import org.eclipse.osee.orcs.core.ds.criteria.BranchCriteria;
import org.eclipse.osee.orcs.core.ds.criteria.CriteriaArtifactIds;
import org.eclipse.osee.orcs.core.ds.criteria.CriteriaRelatedTo;
import org.eclipse.osee.orcs.core.ds.criteria.TxCriteria;
import org.eclipse.osee.orcs.core.internal.search.CriteriaFactory;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.search.ArtifactQueryBuilder;

public class ArtifactQueryBuilderImpl<T>
implements ArtifactQueryBuilder<T> {
    private final CriteriaFactory criteriaFactory;
    private final QueryData queryData;

    public ArtifactQueryBuilderImpl(CriteriaFactory criteriaFactory, QueryData queryData) {
        this.criteriaFactory = criteriaFactory;
        this.queryData = queryData;
    }

    private QueryData getQueryData() {
        return this.queryData;
    }

    private Options getOptions() {
        return this.queryData.getOptions();
    }

    public T includeDeletedAttributes() {
        return this.includeDeletedAttributes(true);
    }

    public T includeDeletedAttributes(boolean enabled) {
        OptionsUtil.setIncludeDeletedAttributes(this.getOptions(), enabled);
        return (T)this;
    }

    public boolean areDeletedAttributesIncluded() {
        return OptionsUtil.areDeletedAttributesIncluded(this.getOptions());
    }

    public T includeDeletedRelations() {
        return this.includeDeletedRelations(true);
    }

    public T includeDeletedRelations(boolean enabled) {
        OptionsUtil.setIncludeDeletedRelations(this.getOptions(), enabled);
        return (T)this;
    }

    public boolean areDeletedRelationsIncluded() {
        return OptionsUtil.areDeletedRelationsIncluded(this.getOptions());
    }

    public T includeDeletedArtifacts() {
        return this.includeDeletedArtifacts(true);
    }

    public T includeDeletedArtifacts(boolean enabled) {
        OptionsUtil.setIncludeDeletedArtifacts(this.getOptions(), enabled);
        return (T)this;
    }

    public boolean areDeletedArtifactsIncluded() {
        return OptionsUtil.areDeletedArtifactsIncluded(this.getOptions());
    }

    public T fromTransaction(TransactionId transaction) {
        OptionsUtil.setFromTransaction(this.getOptions(), transaction);
        return (T)this;
    }

    public TransactionId getFromTransaction() {
        return OptionsUtil.getFromTransaction(this.getOptions());
    }

    public T headTransaction() {
        OptionsUtil.setHeadTransaction(this.getOptions());
        return (T)this;
    }

    public boolean isHeadTransaction() {
        return OptionsUtil.isHeadTransaction(this.getOptions());
    }

    public T excludeDeleted() {
        this.includeDeletedArtifacts(false);
        return (T)this;
    }

    public T andUuid(long id) {
        return this.andId(ArtifactId.valueOf((long)id));
    }

    public T andId(ArtifactId id) {
        return this.addAndCheck(this.queryData, new CriteriaArtifactIds(id));
    }

    public T andIds(ArtifactId id) {
        return this.andId(id);
    }

    public T andIds(Collection<? extends ArtifactId> ids) {
        return this.addAndCheck(this.queryData, new CriteriaArtifactIds(ids));
    }

    public T andUuids(Collection<Long> artifactIds) throws OseeCoreException {
        return this.andIds(artifactIds.stream().map(id -> ArtifactId.valueOf((long)id)).collect(Collectors.toList()));
    }

    public T andGuid(String id) throws OseeCoreException {
        return this.andGuids(Collections.singleton(id));
    }

    public T andGuids(Collection<String> ids) {
        HashSet<String> guids = new HashSet<String>();
        HashSet<String> invalids = new HashSet<String>();
        for (String id : ids) {
            if (GUID.isValid((String)id)) {
                guids.add(id);
                continue;
            }
            invalids.add(id);
        }
        Conditions.checkExpressionFailOnTrue((!invalids.isEmpty() ? 1 : 0) != 0, (String)"Invalid guids detected - %s", (Object[])new Object[]{invalids});
        if (!guids.isEmpty()) {
            Criteria guidCriteria = this.criteriaFactory.createArtifactGuidCriteria(guids);
            this.addAndCheck(this.getQueryData(), guidCriteria);
        }
        return (T)this;
    }

    public T andIsOfType(ArtifactTypeId ... artifactType) {
        return this.andIsOfType(Arrays.asList(artifactType));
    }

    public T andIsOfType(Collection<? extends ArtifactTypeId> artifactType) {
        Criteria criteria = this.criteriaFactory.createArtifactTypeCriteriaWithInheritance(artifactType);
        return this.addAndCheck(this.getQueryData(), criteria);
    }

    public T andTypeEquals(ArtifactTypeId ... artifactType) {
        return this.andTypeEquals(Arrays.asList(artifactType));
    }

    public T andTypeEquals(Collection<? extends ArtifactTypeId> artifactType) {
        Criteria criteria = this.criteriaFactory.createArtifactTypeCriteria(artifactType);
        return this.addAndCheck(this.getQueryData(), criteria);
    }

    public T andExists(AttributeTypeId ... attributeType) {
        return this.andExists(Arrays.asList(attributeType));
    }

    public T andExists(Collection<AttributeTypeId> attributeTypes) {
        Criteria criteria = this.criteriaFactory.createExistsCriteria(attributeTypes);
        return this.addAndCheck(this.getQueryData(), criteria);
    }

    public T andNotExists(AttributeTypeId attributeType) {
        Criteria criteria = this.criteriaFactory.createNotExistsCriteria(attributeType);
        return this.addAndCheck(this.getQueryData(), criteria);
    }

    public T andNotExists(Collection<AttributeTypeId> attributeTypes) {
        Criteria criteria = this.criteriaFactory.createNotExistsCriteria(attributeTypes);
        return this.addAndCheck(this.getQueryData(), criteria);
    }

    public T andExists(IRelationType relationType) {
        Criteria criteria = this.criteriaFactory.createExistsCriteria(relationType);
        return this.addAndCheck(this.getQueryData(), criteria);
    }

    public T andNotExists(IRelationType relationType) {
        Criteria criteria = this.criteriaFactory.createNotExistsCriteria(relationType);
        return this.addAndCheck(this.getQueryData(), criteria);
    }

    public T andNotExists(RelationTypeSide relationTypeSide) {
        Criteria criteria = this.criteriaFactory.createNotExistsCriteria(relationTypeSide);
        return this.addAndCheck(this.getQueryData(), criteria);
    }

    public T andExists(RelationTypeSide relationTypeSide) {
        Criteria criteria = this.criteriaFactory.createExistsCriteria(relationTypeSide);
        return this.addAndCheck(this.getQueryData(), criteria);
    }

    public T and(AttributeTypeId attributeType, Collection<String> values, QueryOption ... options) {
        return this.and(Collections.singleton(attributeType), values, options);
    }

    public T and(AttributeTypeId attributeType, String value, QueryOption ... options) {
        return this.and(Collections.singleton(attributeType), Collections.singleton(value), options);
    }

    public T and(Collection<AttributeTypeId> attributeTypes, String value, QueryOption ... options) {
        return this.and(attributeTypes, Collections.singleton(value), options);
    }

    public T and(Collection<AttributeTypeId> attributeTypes, Collection<String> value, QueryOption ... options) {
        Criteria criteria = this.criteriaFactory.createAttributeCriteria(attributeTypes, value, options);
        return this.addAndCheck(this.getQueryData(), criteria);
    }

    public T andNameEquals(String artifactName) {
        return this.and((AttributeTypeId)CoreAttributeTypes.Name, artifactName, new QueryOption[0]);
    }

    public T andIds(ArtifactId ... ids) {
        return this.andIds(Arrays.asList(ids));
    }

    public T andRelatedTo(RelationTypeSide relationTypeSide, ArtifactReadable ... artifacts) {
        return this.andRelatedTo(relationTypeSide, Arrays.asList(artifacts));
    }

    public T andRelatedTo(RelationTypeSide relationTypeSide, Collection<? extends ArtifactId> artifacts) {
        return this.addAndCheck(this.getQueryData(), new CriteriaRelatedTo(relationTypeSide, artifacts));
    }

    public T andRelatedTo(RelationTypeSide relationTypeSide, ArtifactId artifactId) {
        return this.addAndCheck(this.getQueryData(), new CriteriaRelatedTo(relationTypeSide, artifactId));
    }

    public T followRelation(RelationTypeSide relationTypeSide) {
        Criteria criteria = this.criteriaFactory.createFollowRelationType(relationTypeSide);
        this.addAndCheck(this.getQueryData(), criteria);
        this.queryData.newCriteriaSet();
        return (T)this;
    }

    private T addAndCheck(QueryData queryData, Criteria criteria) {
        criteria.checkValid(this.getOptions());
        queryData.addCriteria(criteria);
        return (T)this;
    }

    private boolean hasOnlyBranchOrTxCriterias(Collection<Criteria> criterias) {
        boolean result = true;
        for (Criteria criteria : criterias) {
            if (criteria instanceof TxCriteria || criteria instanceof BranchCriteria) continue;
            result = false;
            break;
        }
        return result;
    }

    public QueryData buildAndCopy() {
        return this.build(true);
    }

    public QueryData build() {
        return this.build(false);
    }

    private QueryData build(boolean clone) {
        QueryData queryData = clone ? this.getQueryData().clone() : this.getQueryData();
        List<Criteria> criterias = queryData.getAllCriteria();
        if (criterias.isEmpty() || this.hasOnlyBranchOrTxCriterias(criterias)) {
            this.addAndCheck(queryData, this.criteriaFactory.createAllArtifactsCriteria());
        }
        return queryData;
    }

    public T andIsHeirarchicalRootArtifact() {
        this.andIds((ArtifactId)CoreArtifactTokens.DefaultHierarchyRoot);
        return (T)this;
    }
}

