/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import org.codehaus.jackson.map.ObjectMapper;
import org.eclipse.osee.framework.core.data.ApplicabilityToken;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchViewData;
import org.eclipse.osee.framework.core.data.FeatureDefinitionData;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.core.enums.CoreTupleTypes;
import org.eclipse.osee.framework.jdk.core.type.HashCollection;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.Pair;
import org.eclipse.osee.framework.jdk.core.type.TriConsumer;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.search.ApplicabilityQuery;
import org.eclipse.osee.orcs.search.TupleQuery;

public class ApplicabilityQueryImpl
implements ApplicabilityQuery {
    private final TupleQuery tupleQuery;

    public ApplicabilityQueryImpl(TupleQuery tupleQuery) {
        this.tupleQuery = tupleQuery;
    }

    public ApplicabilityToken getApplicabilityToken(ArtifactId artId, BranchId branch) {
        ArrayList<ApplicabilityToken> result = new ArrayList<ApplicabilityToken>();
        BiConsumer<Long, String> consumer = (id, name) -> {
            boolean bl = result.add(new ApplicabilityToken(id, name));
        };
        this.tupleQuery.getTupleType2ForArtifactId(artId, branch, consumer);
        if (result.size() == 0) {
            result.add(ApplicabilityToken.BASE);
        }
        return (ApplicabilityToken)result.get(0);
    }

    public List<Pair<ArtifactId, ApplicabilityToken>> getApplicabilityTokens(Collection<? extends ArtifactId> artIds, BranchId branch) {
        ArrayList<Pair<ArtifactId, ApplicabilityToken>> result = new ArrayList<Pair<ArtifactId, ApplicabilityToken>>();
        TriConsumer consumer = (artId, id, name) -> {
            boolean bl = result.add(new Pair(artId, (Object)new ApplicabilityToken(id, name)));
        };
        this.tupleQuery.getTuple2ForArtifactIds(CoreTupleTypes.ViewApplicability, artIds, branch, consumer);
        return result;
    }

    public HashMap<Long, ApplicabilityToken> getApplicabilityTokens(BranchId branch) {
        HashMap<Long, ApplicabilityToken> tokens = new HashMap<Long, ApplicabilityToken>();
        BiConsumer<Long, String> consumer = (id, name) -> {
            ApplicabilityToken applicabilityToken = tokens.put((Long)id, new ApplicabilityToken(id, name));
        };
        this.tupleQuery.getTuple2UniqueE2Pair(CoreTupleTypes.ViewApplicability, branch, consumer);
        if (tokens.isEmpty()) {
            tokens.put(1L, ApplicabilityToken.BASE);
        }
        return tokens;
    }

    public HashMap<Long, ApplicabilityToken> getApplicabilityTokens(BranchId branch1, BranchId branch2) {
        HashMap<Long, ApplicabilityToken> tokens = new HashMap<Long, ApplicabilityToken>();
        BiConsumer<Long, String> consumer = (id, name) -> {
            ApplicabilityToken applicabilityToken = tokens.put((Long)id, new ApplicabilityToken(id, name));
        };
        this.tupleQuery.getTuple2UniqueE2Pair(CoreTupleTypes.ViewApplicability, branch1, consumer);
        this.tupleQuery.getTuple2UniqueE2Pair(CoreTupleTypes.ViewApplicability, branch2, consumer);
        return tokens;
    }

    public List<FeatureDefinitionData> getFeatureDefinitionData(List<ArtifactReadable> featureDefinitionArts) {
        ArrayList<FeatureDefinitionData> featureDefinition = new ArrayList<FeatureDefinitionData>();
        for (ArtifactReadable art : featureDefinitionArts) {
            String json = art.getSoleAttributeAsString((AttributeTypeId)CoreAttributeTypes.GeneralStringData);
            ObjectMapper mapper = new ObjectMapper();
            try {
                FeatureDefinitionData[] readValue = (FeatureDefinitionData[])mapper.readValue(json, FeatureDefinitionData[].class);
                featureDefinition.addAll(Arrays.asList(readValue));
            }
            catch (Exception e) {
                throw new OseeCoreException((Throwable)e, String.format("Invalid JSON in general string data attribute on artifactId [%s]", art.getId()), new Object[0]);
            }
        }
        return featureDefinition;
    }

    public Map<String, List<String>> getNamedViewApplicabilityMap(BranchId branch, ArtifactId viewId) {
        TreeMap<String, List<String>> toReturn = new TreeMap<String, List<String>>();
        List<ApplicabilityToken> appTokens = this.getViewApplicabilityTokens(viewId, branch);
        for (ApplicabilityToken app : appTokens) {
            String[] split;
            if (app.getName().equalsIgnoreCase("Base") || app.getName().contains("|") || app.getName().contains("&") || app.getName().toLowerCase().contains("config") || (split = app.getName().split("=")).length != 2) continue;
            String name = split[0].trim().toUpperCase();
            String value = split[1].trim();
            if (toReturn.containsKey(name)) {
                ArrayList<String> list = new ArrayList<String>();
                list.addAll((Collection)toReturn.get(name));
                list.add(value);
                toReturn.put(name, list);
                continue;
            }
            toReturn.put(name, Arrays.asList(value));
        }
        return toReturn;
    }

    public List<ApplicabilityToken> getViewApplicabilityTokens(ArtifactId artId, BranchId branch) {
        ArrayList<ApplicabilityToken> result = new ArrayList<ApplicabilityToken>();
        BiConsumer<Long, String> consumer = (id, name) -> {
            boolean bl = result.add(new ApplicabilityToken(id, name));
        };
        this.tupleQuery.getTuple2KeyValuePair(CoreTupleTypes.ViewApplicability, (Object)artId, branch, consumer);
        return result;
    }

    public List<BranchViewData> getViews() {
        HashCollection branchAndViewIds = new HashCollection();
        BiConsumer<Long, Long> consumer = (branchId, artifactId) -> {
            Collection collection = branchAndViewIds.put((Object)BranchId.valueOf((long)branchId), (Object)ArtifactId.valueOf((long)artifactId));
        };
        this.tupleQuery.getTuple2E1E2Pair(CoreTupleTypes.BranchView, BranchId.valueOf((long)CoreBranches.COMMON.getId()), consumer);
        ArrayList<BranchViewData> branchViews = new ArrayList<BranchViewData>();
        for (BranchId branchId2 : branchAndViewIds.keySet()) {
            List values = (List)branchAndViewIds.getValues((Object)branchId2);
            branchViews.add(new BranchViewData(branchId2, values));
        }
        return branchViews;
    }
}

