/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.script.impl;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.IArtifactType;
import org.eclipse.osee.framework.core.data.IRelationType;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.enums.BranchState;
import org.eclipse.osee.framework.core.enums.BranchType;
import org.eclipse.osee.framework.core.enums.QueryOption;
import org.eclipse.osee.framework.core.enums.RelationSide;
import org.eclipse.osee.framework.core.enums.TransactionDetailsType;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.orcs.OrcsTypes;
import org.eclipse.osee.orcs.core.ds.DynamicData;
import org.eclipse.osee.orcs.core.ds.DynamicObject;
import org.eclipse.osee.orcs.core.internal.script.OrcsScriptAssembler;
import org.eclipse.osee.orcs.core.internal.script.OrcsScriptInterpreter;
import org.eclipse.osee.orcs.script.dsl.IExpressionResolver;
import org.eclipse.osee.orcs.script.dsl.IFieldResolver;
import org.eclipse.osee.orcs.script.dsl.OsFieldEnum;
import org.eclipse.osee.orcs.script.dsl.orcsScriptDsl.OrcsScript;
import org.eclipse.osee.orcs.script.dsl.orcsScriptDsl.OsArtifactGuidCriteria;
import org.eclipse.osee.orcs.script.dsl.orcsScriptDsl.OsArtifactIdCriteria;
import org.eclipse.osee.orcs.script.dsl.orcsScriptDsl.OsArtifactQueryAll;
import org.eclipse.osee.orcs.script.dsl.orcsScriptDsl.OsArtifactQueryByPredicate;
import org.eclipse.osee.orcs.script.dsl.orcsScriptDsl.OsArtifactTypeEqualsClause;
import org.eclipse.osee.orcs.script.dsl.orcsScriptDsl.OsArtifactTypeInstanceOfClause;
import org.eclipse.osee.orcs.script.dsl.orcsScriptDsl.OsAttributeExistClause;
import org.eclipse.osee.orcs.script.dsl.orcsScriptDsl.OsBranchArchiveFilter;
import org.eclipse.osee.orcs.script.dsl.orcsScriptDsl.OsBranchArchivedCriteria;
import org.eclipse.osee.orcs.script.dsl.orcsScriptDsl.OsBranchChildOfClause;
import org.eclipse.osee.orcs.script.dsl.orcsScriptDsl.OsBranchIdCriteria;
import org.eclipse.osee.orcs.script.dsl.orcsScriptDsl.OsBranchNameEqualsClause;
import org.eclipse.osee.orcs.script.dsl.orcsScriptDsl.OsBranchNamePatternClause;
import org.eclipse.osee.orcs.script.dsl.orcsScriptDsl.OsBranchParentOfClause;
import org.eclipse.osee.orcs.script.dsl.orcsScriptDsl.OsBranchQueryAll;
import org.eclipse.osee.orcs.script.dsl.orcsScriptDsl.OsBranchQueryById;
import org.eclipse.osee.orcs.script.dsl.orcsScriptDsl.OsBranchQueryByPredicate;
import org.eclipse.osee.orcs.script.dsl.orcsScriptDsl.OsBranchState;
import org.eclipse.osee.orcs.script.dsl.orcsScriptDsl.OsBranchStateCriteria;
import org.eclipse.osee.orcs.script.dsl.orcsScriptDsl.OsBranchType;
import org.eclipse.osee.orcs.script.dsl.orcsScriptDsl.OsBranchTypeCriteria;
import org.eclipse.osee.orcs.script.dsl.orcsScriptDsl.OsCollectAllFieldsExpression;
import org.eclipse.osee.orcs.script.dsl.orcsScriptDsl.OsCollectClause;
import org.eclipse.osee.orcs.script.dsl.orcsScriptDsl.OsCollectExpression;
import org.eclipse.osee.orcs.script.dsl.orcsScriptDsl.OsCollectFieldExpression;
import org.eclipse.osee.orcs.script.dsl.orcsScriptDsl.OsCollectObjectExpression;
import org.eclipse.osee.orcs.script.dsl.orcsScriptDsl.OsExistenceOperator;
import org.eclipse.osee.orcs.script.dsl.orcsScriptDsl.OsExpression;
import org.eclipse.osee.orcs.script.dsl.orcsScriptDsl.OsFollowRelationType;
import org.eclipse.osee.orcs.script.dsl.orcsScriptDsl.OsLimitClause;
import org.eclipse.osee.orcs.script.dsl.orcsScriptDsl.OsNonEqualOperator;
import org.eclipse.osee.orcs.script.dsl.orcsScriptDsl.OsOperator;
import org.eclipse.osee.orcs.script.dsl.orcsScriptDsl.OsQueryOption;
import org.eclipse.osee.orcs.script.dsl.orcsScriptDsl.OsQueryStatement;
import org.eclipse.osee.orcs.script.dsl.orcsScriptDsl.OsRelatedToClause;
import org.eclipse.osee.orcs.script.dsl.orcsScriptDsl.OsRelationExistClause;
import org.eclipse.osee.orcs.script.dsl.orcsScriptDsl.OsRelationSide;
import org.eclipse.osee.orcs.script.dsl.orcsScriptDsl.OsTxAuthorIdCriteria;
import org.eclipse.osee.orcs.script.dsl.orcsScriptDsl.OsTxBranchIdCriteria;
import org.eclipse.osee.orcs.script.dsl.orcsScriptDsl.OsTxCommentEqualsClause;
import org.eclipse.osee.orcs.script.dsl.orcsScriptDsl.OsTxCommentPatternClause;
import org.eclipse.osee.orcs.script.dsl.orcsScriptDsl.OsTxCommitIdEqualsClause;
import org.eclipse.osee.orcs.script.dsl.orcsScriptDsl.OsTxCommitIdIsNullClause;
import org.eclipse.osee.orcs.script.dsl.orcsScriptDsl.OsTxHeadOfBranchIdCriteria;
import org.eclipse.osee.orcs.script.dsl.orcsScriptDsl.OsTxIdEqualsClause;
import org.eclipse.osee.orcs.script.dsl.orcsScriptDsl.OsTxIdOpClause;
import org.eclipse.osee.orcs.script.dsl.orcsScriptDsl.OsTxIdRangeClause;
import org.eclipse.osee.orcs.script.dsl.orcsScriptDsl.OsTxQueryAll;
import org.eclipse.osee.orcs.script.dsl.orcsScriptDsl.OsTxQueryById;
import org.eclipse.osee.orcs.script.dsl.orcsScriptDsl.OsTxQueryByPredicate;
import org.eclipse.osee.orcs.script.dsl.orcsScriptDsl.OsTxTimestampOpClause;
import org.eclipse.osee.orcs.script.dsl.orcsScriptDsl.OsTxTimestampRangeClause;
import org.eclipse.osee.orcs.script.dsl.orcsScriptDsl.OsTxType;
import org.eclipse.osee.orcs.script.dsl.orcsScriptDsl.OsTxTypeCriteria;
import org.eclipse.osee.orcs.script.dsl.orcsScriptDsl.OseAttributeOpClause;
import org.eclipse.osee.orcs.script.dsl.orcsScriptDsl.ScriptVersion;
import org.eclipse.osee.orcs.script.dsl.orcsScriptDsl.util.OrcsScriptDslSwitch;
import org.eclipse.osee.orcs.search.ArtifactQueryBuilder;
import org.eclipse.osee.orcs.search.BranchQueryBuilder;
import org.eclipse.osee.orcs.search.Operator;
import org.eclipse.osee.orcs.search.TxQueryBuilder;

public class OrcsScriptInterpreterImpl
implements OrcsScriptInterpreter {
    private final OrcsTypes orcsTypes;
    private final IExpressionResolver resolver;
    private final IFieldResolver fieldResolver;

    public OrcsScriptInterpreterImpl(OrcsTypes orcsTypes, IExpressionResolver resolver, IFieldResolver fieldResolver) {
        this.orcsTypes = orcsTypes;
        this.resolver = resolver;
        this.fieldResolver = fieldResolver;
    }

    @Override
    public void interpret(OrcsScript model, OrcsScriptAssembler assembler) {
        try {
            try {
                assembler.onCompileStart(model);
                OrcsScriptModelVisitor translator = new OrcsScriptModelVisitor(assembler);
                TreeIterator iterator = EcoreUtil.getAllContents((EObject)model, (boolean)true);
                while (iterator.hasNext()) {
                    EObject next = (EObject)iterator.next();
                    translator.doSwitch(next);
                }
            }
            catch (Exception ex) {
                assembler.onError(ex);
                assembler.onCompileEnd();
            }
        }
        finally {
            assembler.onCompileEnd();
        }
    }

    private RelationTypeToken getRelationType(String name) {
        RelationTypeToken toReturn = null;
        for (RelationTypeToken type : this.orcsTypes.getRelationTypes().getAll()) {
            if (!type.getName().equals(name)) continue;
            toReturn = type;
            break;
        }
        return toReturn;
    }

    private IArtifactType getArtifactType(String name) {
        IArtifactType toReturn = null;
        for (IArtifactType type : this.orcsTypes.getArtifactTypes().getAll()) {
            if (!type.getName().equals(name)) continue;
            toReturn = type;
            break;
        }
        return toReturn;
    }

    private final class OrcsScriptModelVisitor
    extends OrcsScriptDslSwitch<Void> {
        private final OrcsScriptAssembler assembler;

        public OrcsScriptModelVisitor(OrcsScriptAssembler assembler) {
            this.assembler = assembler;
        }

        public Void caseScriptVersion(ScriptVersion object) {
            String version = object.getVersion();
            this.assembler.onScriptVersion(version);
            return null;
        }

        public Void caseOsQueryStatement(OsQueryStatement object) {
            this.assembler.onQueryEnd();
            this.assembler.onQueryStart();
            return null;
        }

        public Void caseOsCollectClause(OsCollectClause object) {
            int startLevel = this.assembler.getSelectSetIndex();
            DynamicObject parent = new DynamicObject("root", null);
            parent.setLevel(startLevel - 1);
            this.resolveCollectExpression(object.getExpression(), parent, startLevel);
            DynamicData data = (DynamicData)((Object)Iterables.getFirst(parent.getChildren(), null));
            data.setParent(null);
            long limit = -1L;
            OsLimitClause limitClause = object.getLimit();
            if (limitClause != null) {
                limit = (Long)OrcsScriptInterpreterImpl.this.resolver.resolveSingle(Long.class, limitClause.getLimit());
            }
            this.assembler.addCollect(data, limit);
            return null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void resolveCollectExpression(OsCollectExpression expression, DynamicObject parent, int level) {
            if (expression instanceof OsCollectAllFieldsExpression) {
                for (IFieldResolver.OsField field : OrcsScriptInterpreterImpl.this.fieldResolver.getAllowedFields((EObject)expression)) {
                    this.resolveOsField(field, parent, level);
                }
                return;
            } else {
                DynamicData child = null;
                if (expression instanceof OsCollectFieldExpression) {
                    OsCollectFieldExpression fieldExpr = (OsCollectFieldExpression)expression;
                    String alias = this.resolveAlias(fieldExpr.getAlias());
                    String fieldLiteral = fieldExpr.getName();
                    Set declaredFields = OrcsScriptInterpreterImpl.this.fieldResolver.getDeclaredFields((EObject)fieldExpr);
                    IFieldResolver.OsField field = this.findField(declaredFields, fieldLiteral);
                    if (field == null) throw new OseeStateException("unable to find field for [%s] - declared [%s]", new Object[]{fieldLiteral, declaredFields});
                    child = new DynamicData(field.getId(), alias);
                    child.setFieldName(field.getLiteral());
                    child.setLevel(level);
                } else if (expression instanceof OsCollectObjectExpression) {
                    String objectType;
                    OsCollectObjectExpression objectExpr = (OsCollectObjectExpression)expression;
                    String alias = this.resolveAlias(objectExpr.getAlias());
                    String id = objectType = objectExpr.getName();
                    String literal = objectType;
                    if ("txs".equals(objectType) && !(objectExpr.eContainer() instanceof OsCollectClause)) {
                        String value = (String)parent.getGuid();
                        OsFieldEnum field = null;
                        if ("artifacts".equals(value)) {
                            field = OsFieldEnum.art_txs;
                        } else if ("attributes".equals(value)) {
                            field = OsFieldEnum.attr_txs;
                        } else if ("relations".equals(value)) {
                            field = OsFieldEnum.rel_txs;
                        }
                        if (field != null) {
                            id = field.getId();
                            literal = field.getLiteral();
                        }
                    }
                    DynamicObject dynamicObject = new DynamicObject(id, alias);
                    dynamicObject.setFieldName(literal);
                    dynamicObject.setLevel(level);
                    for (OsCollectExpression childExpr : objectExpr.getExpressions()) {
                        this.resolveCollectExpression(childExpr, dynamicObject, level);
                    }
                    child = dynamicObject;
                }
                if (parent == null || child == null) return;
                parent.addChild(child);
            }
        }

        private IFieldResolver.OsField findField(Set<? extends IFieldResolver.OsField> fields, String literal) {
            IFieldResolver.OsField found = null;
            for (IFieldResolver.OsField osField : fields) {
                if (!literal.equals(osField.getLiteral())) continue;
                found = osField;
                break;
            }
            return found;
        }

        private void resolveOsField(IFieldResolver.OsField field, DynamicObject parent, int level) {
            String fieldName = field.getLiteral();
            if (field.hasChildren()) {
                int newObjectLevel = level;
                DynamicObject child = new DynamicObject(field.getId(), null);
                child.setFieldName(fieldName);
                child.setLevel(newObjectLevel);
                for (IFieldResolver.OsField childField : field.getChildren()) {
                    this.resolveOsField(childField, child, newObjectLevel);
                }
                parent.addChild(child);
            } else {
                DynamicData child = new DynamicData(field.getId(), null);
                child.setFieldName(fieldName);
                child.setLevel(level);
                parent.addChild(child);
            }
        }

        private String resolveAlias(OsExpression aliasExpr) {
            String alias = null;
            if (aliasExpr != null) {
                alias = (String)OrcsScriptInterpreterImpl.this.resolver.resolveSingle(String.class, aliasExpr);
            }
            return alias;
        }

        private TxQueryBuilder<?> newTxQuery() {
            return this.assembler.newTxQuery();
        }

        private TxQueryBuilder<?> getTxQuery() {
            return this.assembler.getTxQuery();
        }

        public Void caseOsTxQueryById(OsTxQueryById object) {
            int id = (Integer)OrcsScriptInterpreterImpl.this.resolver.resolveSingle(Integer.class, object.getName());
            this.newTxQuery().andTxId(TransactionId.valueOf((long)id));
            return null;
        }

        public Void caseOsTxQueryAll(OsTxQueryAll object) {
            this.newTxQuery();
            return null;
        }

        public Void caseOsTxQueryByPredicate(OsTxQueryByPredicate object) {
            this.newTxQuery();
            return null;
        }

        public Void caseOsTxIdEqualsClause(OsTxIdEqualsClause object) {
            List ids = OrcsScriptInterpreterImpl.this.resolver.resolve(Long.class, (List)object.getIds());
            this.getTxQuery().andTxIds((Collection)Lists.transform((List)ids, TransactionId::valueOf));
            return null;
        }

        public Void caseOsTxIdOpClause(OsTxIdOpClause object) {
            Operator op = this.asOperator(object.getOp());
            int id = (Integer)OrcsScriptInterpreterImpl.this.resolver.resolveSingle(Integer.class, object.getId());
            this.getTxQuery().andTxId(op, id);
            return null;
        }

        public Void caseOsTxIdRangeClause(OsTxIdRangeClause object) {
            int fromId = (Integer)OrcsScriptInterpreterImpl.this.resolver.resolveSingle(Integer.class, object.getFromId());
            int toId = (Integer)OrcsScriptInterpreterImpl.this.resolver.resolveSingle(Integer.class, object.getToId());
            this.getTxQuery().andTxId(Operator.GREATER_THAN_EQ, fromId, Operator.LESS_THAN_EQ, toId);
            return null;
        }

        public Void caseOsTxTypeCriteria(OsTxTypeCriteria object) {
            EList states = object.getTypes();
            this.getTxQuery().andIs(this.asTxTypes((List<OsTxType>)states));
            return null;
        }

        public Void caseOsTxCommentEqualsClause(OsTxCommentEqualsClause object) {
            String value = (String)OrcsScriptInterpreterImpl.this.resolver.resolveSingle(String.class, object.getValue());
            this.getTxQuery().andCommentEquals(value);
            return null;
        }

        public Void caseOsTxCommentPatternClause(OsTxCommentPatternClause object) {
            String value = (String)OrcsScriptInterpreterImpl.this.resolver.resolveSingle(String.class, object.getValue());
            this.getTxQuery().andCommentPattern(value);
            return null;
        }

        public Void caseOsTxBranchIdCriteria(OsTxBranchIdCriteria object) {
            List ids = OrcsScriptInterpreterImpl.this.resolver.resolve(Long.class, (List)object.getIds());
            this.getTxQuery().andBranchIds((Collection)ids);
            return null;
        }

        public Void caseOsTxAuthorIdCriteria(OsTxAuthorIdCriteria object) {
            List ids = OrcsScriptInterpreterImpl.this.resolver.resolve(Integer.class, (List)object.getIds());
            this.getTxQuery().andAuthorIds((Collection)ids);
            return null;
        }

        public Void caseOsTxCommitIdEqualsClause(OsTxCommitIdEqualsClause object) {
            List ids = OrcsScriptInterpreterImpl.this.resolver.resolve(Integer.class, (List)object.getIds());
            this.getTxQuery().andCommitIds((Collection)ids);
            return null;
        }

        public Void caseOsTxCommitIdIsNullClause(OsTxCommitIdIsNullClause object) {
            this.getTxQuery().andNullCommitId();
            return null;
        }

        public Void caseOsTxTimestampOpClause(OsTxTimestampOpClause object) {
            Operator op = this.asOperator(object.getOp());
            Date date = (Date)OrcsScriptInterpreterImpl.this.resolver.resolveSingle(Date.class, object.getTimestamp());
            Timestamp timestamp = this.asTimestamp(date);
            this.getTxQuery().andDate(op, timestamp);
            return null;
        }

        public Void caseOsTxTimestampRangeClause(OsTxTimestampRangeClause object) {
            Date from = (Date)OrcsScriptInterpreterImpl.this.resolver.resolveSingle(Date.class, object.getFrom());
            Date to = (Date)OrcsScriptInterpreterImpl.this.resolver.resolveSingle(Date.class, object.getTo());
            this.getTxQuery().andDate(this.asTimestamp(from), this.asTimestamp(to));
            return null;
        }

        public Void caseOsTxHeadOfBranchIdCriteria(OsTxHeadOfBranchIdCriteria object) {
            Long id = (Long)OrcsScriptInterpreterImpl.this.resolver.resolveSingle(Long.class, object.getId());
            this.getTxQuery().andIsHead(BranchId.valueOf((long)id));
            return null;
        }

        private BranchQueryBuilder<?> newBranchQuery() {
            return this.assembler.newBranchQuery();
        }

        private BranchQueryBuilder<?> getBranchQuery() {
            return this.assembler.getBranchQuery();
        }

        public Void caseOsBranchQueryById(OsBranchQueryById object) {
            OsExpression expression = object.getName();
            Class resolvedType = OrcsScriptInterpreterImpl.this.resolver.resolveTypeSingle(expression);
            if (String.class.isAssignableFrom(resolvedType)) {
                String value = (String)OrcsScriptInterpreterImpl.this.resolver.resolveSingle(String.class, expression);
                this.newBranchQuery().andNameEquals(value);
            } else {
                Long id = (Long)OrcsScriptInterpreterImpl.this.resolver.resolveSingle(Long.class, expression);
                this.newBranchQuery().andId(BranchId.valueOf((long)id));
            }
            return null;
        }

        public Void caseOsBranchQueryAll(OsBranchQueryAll object) {
            this.newBranchQuery();
            return null;
        }

        public Void caseOsBranchQueryByPredicate(OsBranchQueryByPredicate object) {
            this.newBranchQuery();
            return null;
        }

        public Void caseOsBranchIdCriteria(OsBranchIdCriteria object) {
            List ids = OrcsScriptInterpreterImpl.this.resolver.resolve(Long.class, (List)object.getIds());
            ArrayList branchIds = new ArrayList(ids.size());
            ids.forEach(id -> {
                boolean bl = branchIds.add(BranchId.valueOf((long)id));
            });
            this.getBranchQuery().andIds(branchIds);
            return null;
        }

        public Void caseOsBranchChildOfClause(OsBranchChildOfClause object) {
            Long id = (Long)OrcsScriptInterpreterImpl.this.resolver.resolveSingle(Long.class, object.getId());
            BranchId branch = this.asBranch(id);
            this.getBranchQuery().andIsChildOf(branch);
            return null;
        }

        public Void caseOsBranchParentOfClause(OsBranchParentOfClause object) {
            Long id = (Long)OrcsScriptInterpreterImpl.this.resolver.resolveSingle(Long.class, object.getId());
            BranchId branch = this.asBranch(id);
            this.getBranchQuery().andIsAncestorOf(branch);
            return null;
        }

        public Void caseOsBranchNameEqualsClause(OsBranchNameEqualsClause object) {
            String value = (String)OrcsScriptInterpreterImpl.this.resolver.resolveSingle(String.class, object.getValue());
            this.getBranchQuery().andNameEquals(value);
            return null;
        }

        public Void caseOsBranchNamePatternClause(OsBranchNamePatternClause object) {
            String value = (String)OrcsScriptInterpreterImpl.this.resolver.resolveSingle(String.class, object.getValue());
            this.getBranchQuery().andNamePattern(value);
            return null;
        }

        public Void caseOsBranchStateCriteria(OsBranchStateCriteria object) {
            EList states = object.getStates();
            this.getBranchQuery().andStateIs(this.asStates((List<OsBranchState>)states));
            return null;
        }

        public Void caseOsBranchTypeCriteria(OsBranchTypeCriteria object) {
            EList states = object.getTypes();
            this.getBranchQuery().andIsOfType(this.asBranchTypes((List<OsBranchType>)states));
            return null;
        }

        public Void caseOsBranchArchivedCriteria(OsBranchArchivedCriteria object) {
            OsBranchArchiveFilter filter = object.getFilter();
            if (OsBranchArchiveFilter.ARCHIVED_EXCLUDED == filter) {
                this.getBranchQuery().excludeArchived();
            } else {
                this.getBranchQuery().includeArchived();
            }
            return null;
        }

        private ArtifactQueryBuilder<?> newArtifactQuery() {
            return this.assembler.newArtifactQuery();
        }

        private ArtifactQueryBuilder<?> getArtifactQuery() {
            return this.assembler.getArtifactQuery();
        }

        public Void caseOsArtifactQueryAll(OsArtifactQueryAll object) {
            this.newArtifactQuery();
            return null;
        }

        public Void caseOsArtifactQueryByPredicate(OsArtifactQueryByPredicate object) {
            this.newArtifactQuery();
            return null;
        }

        public Void caseOsArtifactIdCriteria(OsArtifactIdCriteria object) {
            List ids = OrcsScriptInterpreterImpl.this.resolver.resolve(Long.class, (List)object.getIds());
            this.getArtifactQuery().andUuids((Collection)ids);
            return null;
        }

        public Void caseOsArtifactGuidCriteria(OsArtifactGuidCriteria object) {
            List ids = OrcsScriptInterpreterImpl.this.resolver.resolve(String.class, (List)object.getIds());
            this.getArtifactQuery().andGuids((Collection)ids);
            return null;
        }

        public Void caseOsArtifactTypeEqualsClause(OsArtifactTypeEqualsClause object) {
            this.getArtifactQuery().andTypeEquals(this.asArtifactTypes((List<OsExpression>)object.getTypes()));
            return null;
        }

        public Void caseOsArtifactTypeInstanceOfClause(OsArtifactTypeInstanceOfClause object) {
            this.getArtifactQuery().andIsOfType(this.asArtifactTypes((List<OsExpression>)object.getTypes()));
            return null;
        }

        public Void caseOseAttributeOpClause(OseAttributeOpClause object) {
            Collection<AttributeTypeId> types = this.asAttributeTypes((List<OsExpression>)object.getTypes());
            List values = OrcsScriptInterpreterImpl.this.resolver.resolve(String.class, (List)object.getValues());
            QueryOption[] options = this.asQueryOptions((List<OsQueryOption>)object.getOptions());
            this.getArtifactQuery().and(types, (Collection)values, options);
            return null;
        }

        public Void caseOsAttributeExistClause(OsAttributeExistClause object) {
            this.getArtifactQuery().andExists(this.asAttributeTypes((List<OsExpression>)object.getTypes()));
            return null;
        }

        public Void caseOsRelationExistClause(OsRelationExistClause object) {
            OsExistenceOperator op = object.getOp();
            if (object.getSide() == null) {
                IRelationType type = this.asRelationType(object.getType());
                if (OsExistenceOperator.EXISTS == op) {
                    this.getArtifactQuery().andExists(type);
                } else {
                    this.getArtifactQuery().andNotExists(type);
                }
            } else {
                RelationTypeSide typeSide = this.asRelationTypeSide(object.getType(), object.getSide());
                if (OsExistenceOperator.EXISTS == op) {
                    this.getArtifactQuery().andExists(typeSide);
                } else {
                    this.getArtifactQuery().andNotExists(typeSide);
                }
            }
            return null;
        }

        public Void caseOsRelatedToClause(OsRelatedToClause object) {
            RelationTypeSide typeSide = this.asRelationTypeSide(object.getType(), object.getSide());
            List ids = OrcsScriptInterpreterImpl.this.resolver.resolve(Long.class, (List)object.getIds());
            this.getArtifactQuery().andRelatedTo(typeSide, (Collection)ids.stream().map(id -> ArtifactId.valueOf((long)id)).collect(Collectors.toList()));
            return null;
        }

        public Void caseOsFollowRelationType(OsFollowRelationType object) {
            RelationTypeSide typeSide = this.asRelationTypeSide(object.getType(), object.getSide());
            this.getArtifactQuery().followRelation(typeSide);
            return null;
        }

        private Collection<IArtifactType> asArtifactTypes(List<OsExpression> expressions) {
            LinkedHashSet<IArtifactType> toReturn = new LinkedHashSet<IArtifactType>();
            List resolvedTypes = OrcsScriptInterpreterImpl.this.resolver.resolveTypes(expressions);
            int index = 0;
            while (index < resolvedTypes.size()) {
                Class clazz = (Class)resolvedTypes.get(index);
                OsExpression expression = expressions.get(index);
                if (clazz.isAssignableFrom(String.class)) {
                    String name = (String)OrcsScriptInterpreterImpl.this.resolver.resolveSingle(String.class, expression);
                    toReturn.add(OrcsScriptInterpreterImpl.this.getArtifactType(name));
                } else {
                    long typeId = (Long)OrcsScriptInterpreterImpl.this.resolver.resolveSingle(Long.class, expression);
                    toReturn.add((IArtifactType)OrcsScriptInterpreterImpl.this.orcsTypes.getArtifactTypes().get(Long.valueOf(typeId)));
                }
                ++index;
            }
            return toReturn;
        }

        private Collection<AttributeTypeId> asAttributeTypes(List<OsExpression> expressions) {
            LinkedHashSet<AttributeTypeId> toReturn = new LinkedHashSet<AttributeTypeId>();
            List resolvedTypes = OrcsScriptInterpreterImpl.this.resolver.resolveTypes(expressions);
            int index = 0;
            while (index < resolvedTypes.size()) {
                Class clazz = (Class)resolvedTypes.get(index);
                OsExpression expression = expressions.get(index);
                if (clazz.isAssignableFrom(String.class)) {
                    String name = (String)OrcsScriptInterpreterImpl.this.resolver.resolveSingle(String.class, expression);
                    toReturn.add(OrcsScriptInterpreterImpl.this.orcsTypes.getAttributeTypes().getByName(name));
                } else {
                    long typeId = (Long)OrcsScriptInterpreterImpl.this.resolver.resolveSingle(Long.class, expression);
                    toReturn.add((AttributeTypeId)OrcsScriptInterpreterImpl.this.orcsTypes.getAttributeTypes().get(Long.valueOf(typeId)));
                }
                ++index;
            }
            return toReturn;
        }

        private IRelationType asRelationType(OsExpression expression) {
            RelationTypeToken toReturn;
            Class clazz = OrcsScriptInterpreterImpl.this.resolver.resolveTypeSingle(expression);
            if (clazz.isAssignableFrom(String.class)) {
                String name = (String)OrcsScriptInterpreterImpl.this.resolver.resolveSingle(String.class, expression);
                toReturn = OrcsScriptInterpreterImpl.this.getRelationType(name);
            } else {
                long typeId = (Long)OrcsScriptInterpreterImpl.this.resolver.resolveSingle(Long.class, expression);
                toReturn = (IRelationType)OrcsScriptInterpreterImpl.this.orcsTypes.getRelationTypes().get(Long.valueOf(typeId));
            }
            return toReturn;
        }

        private RelationTypeSide asRelationTypeSide(OsExpression expression, OsRelationSide side) {
            RelationTypeSide toReturn;
            Class clazz = OrcsScriptInterpreterImpl.this.resolver.resolveTypeSingle(expression);
            if (clazz.isAssignableFrom(String.class)) {
                String name = (String)OrcsScriptInterpreterImpl.this.resolver.resolveSingle(String.class, expression);
                RelationTypeToken type = OrcsScriptInterpreterImpl.this.getRelationType(name);
                toReturn = RelationTypeSide.create((RelationTypeToken)type, (RelationSide)this.asSide(side));
            } else {
                long typeId = (Long)OrcsScriptInterpreterImpl.this.resolver.resolveSingle(Long.class, expression);
                toReturn = RelationTypeSide.create((RelationSide)this.asSide(side), (long)typeId, (String)"N/A");
            }
            return toReturn;
        }

        private BranchId asBranch(Long typeId) {
            return BranchId.valueOf((long)typeId);
        }

        private Timestamp asTimestamp(Date date) {
            return new Timestamp(date.getTime());
        }

        private Operator asOperator(OsOperator op) {
            return Operator.valueOf((String)op.getName());
        }

        private Operator asOperator(OsNonEqualOperator op) {
            return Operator.valueOf((String)op.getName());
        }

        private RelationSide asSide(OsRelationSide side) {
            return RelationSide.valueOf((String)side.getName());
        }

        private TransactionDetailsType[] asTxTypes(List<OsTxType> values) {
            LinkedHashSet<TransactionDetailsType> toReturn = new LinkedHashSet<TransactionDetailsType>();
            for (OsTxType value : values) {
                TransactionDetailsType type = TransactionDetailsType.Baselined;
                if (OsTxType.NON_BASELINE == value) {
                    type = TransactionDetailsType.NonBaselined;
                }
                toReturn.add(type);
            }
            return toReturn.toArray(new TransactionDetailsType[toReturn.size()]);
        }

        private BranchState[] asStates(List<OsBranchState> values) {
            LinkedHashSet<BranchState> toReturn = new LinkedHashSet<BranchState>();
            for (OsBranchState value : values) {
                BranchState state = BranchState.valueOf((String)value.getName());
                toReturn.add(state);
            }
            return toReturn.toArray(new BranchState[toReturn.size()]);
        }

        private BranchType[] asBranchTypes(List<OsBranchType> values) {
            LinkedHashSet<BranchType> toReturn = new LinkedHashSet<BranchType>();
            for (OsBranchType value : values) {
                BranchType type = BranchType.valueOf((String)value.getName());
                toReturn.add(type);
            }
            return toReturn.toArray(new BranchType[toReturn.size()]);
        }

        private QueryOption[] asQueryOptions(List<OsQueryOption> options) {
            LinkedHashSet<QueryOption> toReturn = new LinkedHashSet<QueryOption>();
            for (OsQueryOption op : options) {
                if (OsQueryOption.CONTAINS == op) {
                    toReturn.add(QueryOption.CASE__IGNORE);
                    toReturn.add(QueryOption.TOKEN_MATCH_ORDER__MATCH);
                    toReturn.add(QueryOption.TOKEN_DELIMITER__ANY);
                    toReturn.add(QueryOption.TOKEN_COUNT__IGNORE);
                    continue;
                }
                toReturn.add(QueryOption.valueOf((String)op.getName()));
            }
            return toReturn.toArray(new QueryOption[options.size()]);
        }
    }
}

