/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.script.impl;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.osee.executor.admin.CancellableCallable;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.OrcsTypes;
import org.eclipse.osee.orcs.core.ds.CriteriaSet;
import org.eclipse.osee.orcs.core.ds.DataModule;
import org.eclipse.osee.orcs.core.ds.DynamicData;
import org.eclipse.osee.orcs.core.ds.DynamicObject;
import org.eclipse.osee.orcs.core.ds.Options;
import org.eclipse.osee.orcs.core.ds.OptionsUtil;
import org.eclipse.osee.orcs.core.ds.QueryData;
import org.eclipse.osee.orcs.core.ds.QueryEngine;
import org.eclipse.osee.orcs.core.ds.SelectData;
import org.eclipse.osee.orcs.core.ds.SelectSet;
import org.eclipse.osee.orcs.core.internal.script.OrcsScriptAssembler;
import org.eclipse.osee.orcs.core.internal.script.OrcsScriptExecutor;
import org.eclipse.osee.orcs.core.internal.script.OrcsScriptOutputHandler;
import org.eclipse.osee.orcs.core.internal.search.ArtifactQueryBuilderImpl;
import org.eclipse.osee.orcs.core.internal.search.BranchCriteriaFactory;
import org.eclipse.osee.orcs.core.internal.search.BranchQueryBuilderImpl;
import org.eclipse.osee.orcs.core.internal.search.CriteriaFactory;
import org.eclipse.osee.orcs.core.internal.search.TransactionCriteriaFactory;
import org.eclipse.osee.orcs.core.internal.search.TxQueryBuilderImpl;
import org.eclipse.osee.orcs.script.dsl.orcsScriptDsl.OrcsScript;
import org.eclipse.osee.orcs.search.ArtifactQueryBuilder;
import org.eclipse.osee.orcs.search.BranchQueryBuilder;
import org.eclipse.osee.orcs.search.TxQueryBuilder;

public class OrcsScriptAssemblerImpl
implements OrcsScriptAssembler,
OrcsScriptExecutor {
    private static final String SHOW_HIDDEN_FIELDS = "show.hidden.fields";
    private static final String UNKNOWN_VERSION = "0.0.0";
    private final TransactionCriteriaFactory factory1;
    private final BranchCriteriaFactory factory2;
    private final CriteriaFactory factory3;
    private final LinkedList<QueryData> queries = new LinkedList();
    private String version;
    private TxQueryBuilderImpl<?> txQuery;
    private ArtifactQueryBuilderImpl<?> artQuery;
    private BranchQueryBuilderImpl<?> branchQuery;
    private final DataModule dataModule;
    private final OrcsScriptOutputHandler output;
    private boolean errorDetected;

    public OrcsScriptAssemblerImpl(DataModule dataModule, OrcsTypes orcsTypes, OrcsScriptOutputHandler output) {
        this.dataModule = dataModule;
        this.output = output;
        this.factory1 = new TransactionCriteriaFactory();
        this.factory2 = new BranchCriteriaFactory();
        this.factory3 = new CriteriaFactory(orcsTypes.getArtifactTypes(), orcsTypes.getAttributeTypes());
    }

    private void reset() {
        this.errorDetected = false;
        this.queries.clear();
        this.version = UNKNOWN_VERSION;
        this.txQuery = null;
        this.artQuery = null;
        this.branchQuery = null;
    }

    @Override
    public void onCompileStart(OrcsScript model) {
        this.reset();
        this.output.onCompileStart(model);
    }

    @Override
    public void onCompileEnd() {
        this.onQueryEnd();
        this.output.onCompileEnd();
    }

    @Override
    public void onQueryStart() {
        Options options = OptionsUtil.createOptions();
        OptionsUtil.setIncludeDeletedArtifacts(options, false);
        OptionsUtil.setIncludeDeletedAttributes(options, false);
        OptionsUtil.setIncludeDeletedRelations(options, false);
        ArrayList<CriteriaSet> criterias = new ArrayList<CriteriaSet>();
        criterias.add(new CriteriaSet());
        this.queries.add(new QueryData(options, criterias, new SelectData()));
    }

    @Override
    public void onQueryEnd() {
        this.resetTxQuery();
        this.resetBranchQuery();
        this.resetArtifactQuery();
    }

    @Override
    public void onScriptVersion(String version) {
        this.version = version;
    }

    @Override
    public TxQueryBuilder<?> newTxQuery() {
        this.txQuery = new TxQueryBuilderImpl(this.factory1, this.getLastQuery());
        return this.txQuery;
    }

    @Override
    public BranchQueryBuilder<?> newBranchQuery() {
        this.branchQuery = new BranchQueryBuilderImpl(this.factory2, this.getLastQuery());
        return this.branchQuery;
    }

    @Override
    public ArtifactQueryBuilder<?> newArtifactQuery() {
        this.artQuery = new ArtifactQueryBuilderImpl(this.factory3, this.getLastQuery());
        return this.artQuery;
    }

    @Override
    public TxQueryBuilder<?> getTxQuery() {
        return this.txQuery;
    }

    @Override
    public BranchQueryBuilder<?> getBranchQuery() {
        return this.branchQuery;
    }

    @Override
    public ArtifactQueryBuilder<?> getArtifactQuery() {
        if (this.artQuery == null) {
            this.newArtifactQuery();
        }
        return this.artQuery;
    }

    @Override
    public void resetTxQuery() {
        if (this.txQuery != null) {
            this.txQuery.build();
        }
        this.txQuery = null;
    }

    @Override
    public void resetBranchQuery() {
        if (this.branchQuery != null) {
            this.branchQuery.build();
        }
        this.branchQuery = null;
    }

    @Override
    public void resetArtifactQuery() {
        if (this.artQuery != null) {
            this.artQuery.build();
        }
        this.artQuery = null;
    }

    public String getVersion() {
        return this.version;
    }

    private QueryData getLastQuery() {
        return this.queries.getLast();
    }

    private SelectSet getLastSelect() {
        return this.getLastQuery().getSelectSet();
    }

    @Override
    public void addCollect(DynamicData data, long limit) {
        SelectSet select;
        if (data != null && (select = this.getLastSelect()) != null) {
            select.setLimit(limit);
            DynamicData oldData = select.getData();
            if (oldData != null) {
                DynamicObject obj = (DynamicObject)oldData;
                obj.addChild(data);
            } else {
                select.setData(data);
            }
        }
    }

    @Override
    public void onError(Throwable error) {
        this.errorDetected = true;
        this.output.onError(error);
    }

    @Override
    public Object execute(OrcsSession session, Map<String, Object> parameters) {
        Object result = null;
        try {
            try {
                this.output.onExecutionStart(this.version);
                result = this.executionHelper(session, parameters);
            }
            catch (Exception ex) {
                this.output.onError(ex);
                this.output.onExecutionEnd();
            }
        }
        finally {
            this.output.onExecutionEnd();
        }
        return result;
    }

    private boolean showHiddenFields(Map<String, Object> parameters) {
        Object hiddenFields = parameters.get(SHOW_HIDDEN_FIELDS);
        return Boolean.parseBoolean(String.valueOf(hiddenFields));
    }

    private Object executionHelper(OrcsSession session, Map<String, Object> parameters) {
        int results = -1;
        if (!this.errorDetected) {
            boolean showHiddenFields = this.showHiddenFields(parameters);
            QueryEngine queryEngine = this.dataModule.getQueryEngine();
            for (QueryData queryData : this.queries) {
                try {
                    try {
                        OptionsUtil.setShowHiddenFields(queryData.getOptions(), showHiddenFields);
                        this.output.onQueryStart(queryData);
                        CancellableCallable<Integer> op = queryEngine.createQuery(session, queryData, this.output);
                        results += ((Integer)op.call()).intValue();
                    }
                    catch (Exception ex) {
                        this.output.onError(ex);
                        this.output.onQueryEnd();
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    this.output.onQueryEnd();
                    throw throwable;
                }
                this.output.onQueryEnd();
            }
        }
        return results;
    }

    @Override
    public int getSelectSetIndex() {
        int index = 0;
        QueryData lastQuery = this.getLastQuery();
        if (lastQuery != null) {
            List<SelectSet> selectSets = lastQuery.getSelectSets();
            index = selectSets.size() - 1;
        }
        return index;
    }

    protected LinkedList<QueryData> getQueries() {
        return this.queries;
    }
}

