/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.script.impl;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.script.ScriptContext;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.orcs.core.ds.CharacterDataProxy;

public class JsonOutputMath {
    private String attribute = null;
    private boolean doSum;
    private boolean doCount;
    private boolean doAverage;
    private boolean doMax;
    private boolean doMin;
    private LinkedList<Double> attributeValues;
    private static String OUTPUT_ATTR = "calc.attribute";
    private static String OUTPUT_SUM = "calc.sum";
    private static String OUTPUT_COUNT = "calc.count";
    private static String OUTPUT_AVG = "calc.avg";
    private static String OUTPUT_MAX = "calc.max";
    private static String OUTPUT_MIN = "calc.min";

    public void initialize(ScriptContext context) {
        Object attr = context.getAttribute(OUTPUT_ATTR);
        if (attr != null) {
            this.attribute = String.valueOf(attr);
        }
        Object sum = context.getAttribute(OUTPUT_SUM);
        this.doSum = Boolean.parseBoolean(String.valueOf(sum));
        Object count = context.getAttribute(OUTPUT_COUNT);
        this.doCount = Boolean.parseBoolean(String.valueOf(count));
        Object average = context.getAttribute(OUTPUT_AVG);
        this.doAverage = Boolean.parseBoolean(String.valueOf(average));
        Object max = context.getAttribute(OUTPUT_MAX);
        this.doMax = Boolean.parseBoolean(String.valueOf(max));
        Object min = context.getAttribute(OUTPUT_MIN);
        this.doMin = Boolean.parseBoolean(String.valueOf(min));
        this.attributeValues = new LinkedList();
    }

    public boolean isUsed() {
        boolean toReturn = false;
        if (this.attribute != null && (this.doSum || this.doCount || this.doAverage || this.doMax || this.doMin)) {
            toReturn = true;
        }
        return toReturn;
    }

    public void add(Map<String, Object> data) {
        Object value;
        Object attr = data.get("attributes");
        if (attr != null && attr instanceof Map && (value = ((Map)attr).get(this.attribute)) != null && value instanceof Map) {
            for (Object item : ((Map)value).values()) {
                String element;
                if (!(item instanceof CharacterDataProxy) || !Strings.isNumeric((String)(element = ((CharacterDataProxy)item).getValueAsString()))) continue;
                this.attributeValues.add(Double.valueOf(element));
            }
        }
    }

    public void write(JsonGenerator writer) throws JsonGenerationException, IOException {
        if (!this.attributeValues.isEmpty()) {
            writer.writeStartObject();
            if (this.attribute != null) {
                writer.writeObjectFieldStart("calculations");
                writer.writeFieldName("attribute");
                writer.writeString(this.attribute);
                if (this.doSum) {
                    writer.writeFieldName("sum");
                    writer.writeNumber(this.getSum());
                }
                if (this.doCount) {
                    writer.writeFieldName("count");
                    writer.writeNumber(this.attributeValues.size());
                }
                if (this.doAverage) {
                    writer.writeFieldName("average");
                    writer.writeNumber(this.getAverage());
                }
                if (this.doMax) {
                    writer.writeFieldName("max");
                    writer.writeNumber(this.getMax());
                }
                if (this.doMin) {
                    writer.writeFieldName("min");
                    writer.writeNumber(this.getMin());
                }
                writer.writeEndObject();
            }
            writer.writeEndObject();
        }
    }

    public double getSum() {
        double toReturn = 0.0;
        if (!this.attributeValues.isEmpty()) {
            Iterator iterator = this.attributeValues.iterator();
            while (iterator.hasNext()) {
                double value = (Double)iterator.next();
                toReturn += value;
            }
        }
        return toReturn;
    }

    public double getAverage() {
        double toReturn = 0.0;
        toReturn = this.attributeValues.size() > 0 ? this.getSum() / (double)this.attributeValues.size() : Double.NaN;
        return toReturn;
    }

    public double getMax() {
        double toReturn = Double.NEGATIVE_INFINITY;
        if (!this.attributeValues.isEmpty()) {
            Iterator iterator = this.attributeValues.iterator();
            while (iterator.hasNext()) {
                double value = (Double)iterator.next();
                if (!(value > toReturn)) continue;
                toReturn = value;
            }
        }
        return toReturn;
    }

    public double getMin() {
        double toReturn = Double.POSITIVE_INFINITY;
        if (!this.attributeValues.isEmpty()) {
            Iterator iterator = this.attributeValues.iterator();
            while (iterator.hasNext()) {
                double value = (Double)iterator.next();
                if (!(value < toReturn)) continue;
                toReturn = value;
            }
        }
        return toReturn;
    }
}

