/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.script.impl;

import com.google.common.collect.Iterables;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.script.ScriptContext;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.PrettyPrinter;
import org.codehaus.jackson.Version;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.Module;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.map.SerializerProvider;
import org.codehaus.jackson.map.module.SimpleModule;
import org.codehaus.jackson.map.ser.std.SerializerBase;
import org.codehaus.jackson.util.DefaultPrettyPrinter;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.core.ds.BinaryDataProxy;
import org.eclipse.osee.orcs.core.ds.CharacterDataProxy;
import org.eclipse.osee.orcs.core.ds.Criteria;
import org.eclipse.osee.orcs.core.ds.CriteriaSet;
import org.eclipse.osee.orcs.core.ds.DataProxy;
import org.eclipse.osee.orcs.core.ds.DynamicData;
import org.eclipse.osee.orcs.core.ds.DynamicObject;
import org.eclipse.osee.orcs.core.ds.LoadDescription;
import org.eclipse.osee.orcs.core.ds.Options;
import org.eclipse.osee.orcs.core.ds.QueryData;
import org.eclipse.osee.orcs.core.ds.SelectSet;
import org.eclipse.osee.orcs.core.internal.script.OrcsScriptOutputHandler;
import org.eclipse.osee.orcs.core.internal.script.impl.JsonOutputMath;
import org.eclipse.osee.orcs.script.dsl.OrcsScriptUtil;
import org.eclipse.osee.orcs.script.dsl.orcsScriptDsl.OrcsScript;

public class JsonOutputHandler
extends OrcsScriptOutputHandler {
    private static String OUTPUT_SCRIPT = "output.script";
    private static String OUTPUT_DEBUG = "output.debug";
    private final ScriptContext context;
    private JsonGenerator writer;
    private List<Throwable> errors;
    private DebugInfo debugInfo;
    private boolean isDebugModeEnabled;
    private boolean isScriptOutputEnabled;
    JsonOutputMath mathOut;
    private DynamicData first;
    private boolean wasStarted;

    public JsonOutputHandler(ScriptContext context) {
        this.context = context;
    }

    private void initalizeData() {
        this.isScriptOutputEnabled = true;
        this.mathOut = new JsonOutputMath();
        this.mathOut.initialize(this.context);
        Object debug = this.context.getAttribute(OUTPUT_DEBUG);
        this.isDebugModeEnabled = Boolean.parseBoolean(String.valueOf(debug));
        Object outputScript = this.context.getAttribute(OUTPUT_SCRIPT);
        if (outputScript != null) {
            this.isScriptOutputEnabled = this.isDebugModeEnabled || Boolean.parseBoolean(String.valueOf(outputScript));
        }
        this.debugInfo = this.isDebugModeEnabled ? new DebugInfo() : null;
        this.errors = null;
    }

    @Override
    public void onEvalStart() {
        super.onEvalStart();
        this.initalizeData();
        try {
            ObjectMapper mapper = new ObjectMapper();
            mapper.setDateFormat((DateFormat)new SimpleDateFormat("MM/dd/yyyy hh:mm:ss a"));
            mapper.configure(SerializationConfig.Feature.SORT_PROPERTIES_ALPHABETICALLY, true);
            mapper.configure(SerializationConfig.Feature.WRAP_EXCEPTIONS, true);
            mapper.configure(SerializationConfig.Feature.WRITE_EMPTY_JSON_ARRAYS, false);
            mapper.configure(SerializationConfig.Feature.WRITE_NULL_MAP_VALUES, true);
            SimpleModule module = new SimpleModule("DataProxy", new Version(1, 0, 0, null));
            module.addSerializer(DataProxy.class, (JsonSerializer)new DataProxySerializer(DataProxy.class));
            mapper.registerModule((Module)module);
            JsonFactory jsonFactory = mapper.getJsonFactory();
            this.writer = jsonFactory.createJsonGenerator(this.context.getWriter());
            this.writer.setPrettyPrinter((PrettyPrinter)new DefaultPrettyPrinter());
            this.writer.writeStartObject();
        }
        catch (IOException ex) {
            throw new OseeCoreException((Throwable)ex);
        }
    }

    @Override
    public void onError(Throwable th) {
        if (this.errors == null) {
            this.errors = new ArrayList<Throwable>();
        }
        this.errors.add(th);
    }

    @Override
    public void onCompileStart(OrcsScript model) {
        super.onCompileStart(model);
        if (this.isScriptOutputEnabled) {
            try {
                this.writeScriptData(model);
            }
            catch (IOException ex) {
                throw new OseeCoreException((Throwable)ex);
            }
        }
    }

    @Override
    public void onExecutionStart(String version) {
        super.onExecutionStart(version);
        if (this.isDebugModeEnabled) {
            this.debugInfo.setScriptVersion(version);
        }
    }

    @Override
    public void onQueryStart(QueryData data) {
        super.onQueryStart(data);
        if (this.isDebugModeEnabled) {
            this.debugInfo.addQuery(data);
        }
    }

    @Override
    public void onQueryEnd() {
        super.onQueryEnd();
    }

    @Override
    public void onLoadStart() throws OseeCoreException {
        super.onLoadStart();
        try {
            this.writer.writeArrayFieldStart("results");
        }
        catch (IOException ex) {
            throw new OseeCoreException((Throwable)ex);
        }
    }

    @Override
    public void onLoadDescription(LoadDescription data) throws OseeCoreException {
        super.onLoadDescription(data);
        this.first = (DynamicData)((Object)Iterables.getFirst(data.getObjectDescription().getDynamicData(), null));
        this.wasStarted = false;
        if (this.debugInfo != null) {
            this.debugInfo.addDescription(data);
        }
    }

    @Override
    public void onDynamicData(Map<String, Object> data) throws OseeCoreException {
        super.onDynamicData(data);
        try {
            if (!this.wasStarted && this.first != null) {
                this.wasStarted = true;
                this.writer.writeStartObject();
                this.writer.writeArrayFieldStart(this.first.getName());
            }
            if (this.mathOut.isUsed()) {
                this.mathOut.add(data);
            }
            this.writer.writeObject(data);
        }
        catch (IOException ex) {
            throw new OseeCoreException((Throwable)ex);
        }
    }

    @Override
    public void onLoadEnd() throws OseeCoreException {
        super.onLoadEnd();
        try {
            if (this.wasStarted) {
                this.writer.writeEndArray();
                this.writer.writeEndObject();
            }
            if (this.mathOut.isUsed()) {
                this.mathOut.write(this.writer);
            }
            this.writer.writeEndArray();
        }
        catch (IOException ex) {
            throw new OseeCoreException((Throwable)ex);
        }
    }

    @Override
    public void onExecutionEnd() {
        super.onExecutionEnd();
    }

    @Override
    public void onEvalEnd() {
        super.onEvalEnd();
        try {
            try {
                this.writeErrors();
                this.writeDebug();
            }
            finally {
                this.writer.writeEndObject();
                this.writer.flush();
            }
        }
        catch (IOException ex) {
            throw new OseeCoreException((Throwable)ex);
        }
    }

    private void writeScriptData(OrcsScript model) throws IOException {
        Map binding = OrcsScriptUtil.getBinding((EObject)model);
        if (binding != null && !binding.isEmpty()) {
            this.writer.writeFieldName("parameters");
            this.writer.writeStartObject();
            for (Map.Entry entry : binding.entrySet()) {
                this.writer.writeStringField((String)entry.getKey(), String.valueOf(entry.getValue()));
            }
            this.writer.writeEndObject();
        }
        this.writer.writeFieldName("script");
        String value = "N/A";
        try {
            if (model != null && model.eAllContents().hasNext()) {
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                OrcsScriptUtil.saveModel((OrcsScript)model, (String)"orcs:/unknown.orcs", (OutputStream)outputStream, (OrcsScriptUtil.OsStorageOption[])new OrcsScriptUtil.OsStorageOption[]{OrcsScriptUtil.OsStorageOption.NO_VALIDATION_ON_SAVE});
                value = outputStream.toString("UTF-8");
            }
        }
        catch (Exception ex) {
            value = ex.getMessage();
        }
        this.writer.writeString(value);
    }

    private void writeErrors() throws IOException {
        if (this.errors != null && !this.errors.isEmpty()) {
            Writer errorWriter = this.context.getErrorWriter();
            if (errorWriter != null && errorWriter != this.context.getWriter()) {
                for (Throwable th : this.errors) {
                    errorWriter.write(Lib.exceptionToString((Throwable)th));
                }
            } else {
                this.writer.writeArrayFieldStart("errors");
                for (Throwable th : this.errors) {
                    this.writer.writeString(Lib.exceptionToString((Throwable)th));
                }
                this.writer.writeEndArray();
            }
        }
    }

    private void writeDebug() throws JsonGenerationException, IOException {
        if (this.debugInfo != null) {
            this.writer.writeFieldName("debug");
            this.writer.writeStartObject();
            this.writer.writeStringField("script-version", this.debugInfo.getScriptVersion());
            List<LoadDescription> descriptions = this.debugInfo.getDescriptions();
            List<QueryData> queries = this.debugInfo.getQueries();
            int index = 0;
            while (index < descriptions.size()) {
                this.writer.writeFieldName("query_" + index);
                this.writer.writeStartObject();
                LoadDescription description = descriptions.get(index);
                OrcsSession session = description.getSession();
                if (session != null) {
                    this.writer.writeStringField("session", (String)session.getGuid());
                }
                Options options = description.getOptions();
                for (String key : new TreeSet<String>(options.getKeys())) {
                    this.writer.writeStringField(key, options.get(key).replaceAll("\\s+", " "));
                }
                this.writeQuery(queries.get(index));
                this.writer.writeEndObject();
                ++index;
            }
            this.writer.writeEndObject();
        }
    }

    private void writeQuery(QueryData queryData) throws IOException {
        List<CriteriaSet> criteriaSets = queryData.getCriteriaSets();
        List<SelectSet> selectSets = queryData.getSelectSets();
        this.writer.writeArrayFieldStart("query");
        int index = 0;
        while (index < criteriaSets.size()) {
            this.writer.writeStartObject();
            this.writer.writeNumberField("level", index);
            this.writeCriterias(criteriaSets.get(index));
            this.writeCollect(selectSets.get(index));
            this.writer.writeEndObject();
            ++index;
        }
        this.writer.writeEndArray();
    }

    private void writeCriterias(CriteriaSet criteriaSet) throws IOException {
        this.writer.writeArrayFieldStart("criteria");
        for (Criteria criteria : criteriaSet.getCriterias()) {
            String value = criteria.toString();
            value = value.replaceAll("\\[", "");
            value = value.replaceAll("\\]", "");
            this.writer.writeObject((Object)value);
        }
        this.writer.writeEndArray();
    }

    private void writeCollect(SelectSet selectSet) throws IOException {
        this.writer.writeFieldName("collect");
        this.writer.writeStartObject();
        this.writer.writeNumberField("limit", selectSet.getLimit());
        this.writeDynamicData(selectSet.getData());
        this.writer.writeEndObject();
    }

    private void writeDynamicData(DynamicData data) throws JsonGenerationException, IOException {
        if (data != null) {
            if (data instanceof DynamicObject) {
                DynamicObject obj = (DynamicObject)data;
                if (obj.hasChildren()) {
                    this.writer.writeFieldName(data.getName());
                    this.writer.writeStartObject();
                    for (DynamicData child : obj.getChildren()) {
                        this.writeDynamicData(child);
                    }
                    this.writer.writeEndObject();
                }
            } else {
                StringBuilder value = new StringBuilder();
                if (data.isHidden()) {
                    value.append("hidden->");
                }
                value.append((String)data.getGuid());
                if (data.isPrimaryKey()) {
                    value.append("*");
                }
                this.writer.writeStringField(data.getName(), value.toString());
            }
        }
    }

    private static final class DataProxySerializer
    extends SerializerBase<DataProxy> {
        protected DataProxySerializer(Class<DataProxy> t) {
            super(t);
        }

        public void serialize(DataProxy proxy, JsonGenerator writer, SerializerProvider provider) throws IOException, JsonGenerationException {
            if (proxy instanceof CharacterDataProxy) {
                CharacterDataProxy characters = (CharacterDataProxy)proxy;
                writer.writeObject((Object)characters.getValueAsString());
            } else if (proxy instanceof BinaryDataProxy) {
                BinaryDataProxy binary = (BinaryDataProxy)proxy;
                ByteBuffer buffer = binary.getValueAsBytes();
                InputStream inputStream = null;
                try {
                    inputStream = Lib.byteBufferToInputStream((ByteBuffer)buffer);
                    writer.writeBinary(Lib.inputStreamToBytes((InputStream)inputStream));
                }
                finally {
                    Lib.close((Closeable)inputStream);
                }
            }
        }
    }

    private static final class DebugInfo {
        public String scriptVersion;
        public final List<LoadDescription> descriptions = new ArrayList<LoadDescription>();
        private final List<QueryData> queries = new ArrayList<QueryData>();

        private DebugInfo() {
        }

        public void setScriptVersion(String version) {
            this.scriptVersion = version;
        }

        public void addDescription(LoadDescription data) {
            this.descriptions.add(data);
        }

        public void addQuery(QueryData queryData) {
            this.queries.add(queryData);
        }

        public String getScriptVersion() {
            return this.scriptVersion;
        }

        public List<LoadDescription> getDescriptions() {
            return this.descriptions;
        }

        public List<QueryData> getQueries() {
            return this.queries;
        }
    }
}

