/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.script;

import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import org.eclipse.osee.orcs.core.internal.script.OrcsScriptCompiler;
import org.eclipse.osee.orcs.core.internal.script.OrcsScriptEngineFactory;

public final class ScriptEngines {
    public static final String ORCS_SCRIPT_ENGINE_ID = "orcs";

    private ScriptEngines() {
    }

    public static ScriptEngineManager newScriptEngineManager(OrcsScriptCompiler compiler) {
        OrcsScriptEngineFactory factory = new OrcsScriptEngineFactory(compiler);
        ScriptEngineManager manager = new ScriptEngineManager();
        ScriptEngines.registerEngine(manager, factory);
        return manager;
    }

    private static void registerEngine(ScriptEngineManager manager, ScriptEngineFactory factory) {
        for (String extension : factory.getExtensions()) {
            manager.registerEngineExtension(extension, factory);
        }
        for (String type : factory.getMimeTypes()) {
            manager.registerEngineMimeType(type, factory);
        }
        for (String name : factory.getNames()) {
            manager.registerEngineName(name, factory);
        }
    }
}

