/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.script;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import org.eclipse.osee.orcs.core.internal.script.OrcsScriptCompiler;
import org.eclipse.osee.orcs.core.internal.script.OrcsScriptEngine;

public class OrcsScriptEngineFactory
implements ScriptEngineFactory {
    private static final String THREADING = "THREADING";
    private static final String STATELESS_THREADING = "STATELESS";
    private static final String SCRIPT_LANGUAGE_NAME = "ORCS Script";
    private static final String SCRIPT_NAME = "orcsscript";
    private static final String SCRIPT_ENGINE_NAME = "ORCS Script Engine";
    private static final String SCRIPT_LANGUAGE_VERSION = "1.0.0";
    private static final String SCRIPT_ENGINE_VERSION = "1.0.0";
    private static List<String> extensions;
    private static List<String> mimeTypes;
    private static List<String> aliases;
    private final OrcsScriptCompiler compiler;

    static {
        ArrayList<String> names = new ArrayList<String>(6);
        names.add("orcs");
        names.add("OrcsScript");
        names.add(SCRIPT_NAME);
        names.add("OrcsDsl");
        names.add("orcsdsl");
        aliases = Collections.unmodifiableList(names);
        ArrayList<String> mimeTypes = new ArrayList<String>(4);
        mimeTypes.add("application/orcsscript");
        mimeTypes.add("text/orcsscript");
        OrcsScriptEngineFactory.mimeTypes = Collections.unmodifiableList(mimeTypes);
        ArrayList<String> extensions = new ArrayList<String>(1);
        extensions.add("orcs");
        OrcsScriptEngineFactory.extensions = Collections.unmodifiableList(extensions);
    }

    public OrcsScriptEngineFactory(OrcsScriptCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public ScriptEngine getScriptEngine() {
        OrcsScriptEngine engine = new OrcsScriptEngine(this.compiler);
        engine.setEngineFactory(this);
        return engine;
    }

    @Override
    public List<String> getExtensions() {
        return extensions;
    }

    @Override
    public List<String> getMimeTypes() {
        return mimeTypes;
    }

    @Override
    public List<String> getNames() {
        return aliases;
    }

    public String getName() {
        return this.getParameter("javax.script.name");
    }

    @Override
    public String getEngineName() {
        return this.getParameter("javax.script.engine");
    }

    @Override
    public String getEngineVersion() {
        return this.getParameter("javax.script.engine_version");
    }

    @Override
    public String getLanguageName() {
        return this.getParameter("javax.script.language");
    }

    @Override
    public String getLanguageVersion() {
        return this.getParameter("javax.script.language_version");
    }

    @Override
    public String getParameter(String key) {
        String toReturn = null;
        if (key.equals("javax.script.name")) {
            toReturn = SCRIPT_NAME;
        } else if (key.equals("javax.script.engine")) {
            toReturn = SCRIPT_ENGINE_NAME;
        } else if (key.equals("javax.script.language")) {
            toReturn = SCRIPT_LANGUAGE_NAME;
        } else if (key.equals("javax.script.engine_version")) {
            toReturn = "1.0.0";
        } else if (key.equals("javax.script.language_version")) {
            toReturn = "1.0.0";
        } else if (key.equals(THREADING)) {
            toReturn = STATELESS_THREADING;
        }
        if (toReturn == null) {
            throw new IllegalArgumentException("Invalid key");
        }
        return toReturn;
    }

    @Override
    public String getMethodCallSyntax(String obj, String method, String ... args) {
        StringBuilder builder = new StringBuilder().append(obj).append(".").append(method).append("(");
        int argSize = args.length;
        if (argSize > 0) {
            int index = 0;
            while (index < argSize) {
                builder.append(args[index]);
                if (index != argSize - 1) {
                    builder.append(",");
                } else {
                    builder.append(")");
                }
                ++index;
            }
        } else {
            builder.append(")");
        }
        return builder.toString();
    }

    @Override
    public String getOutputStatement(String toDisplay) {
        StringBuilder builder = new StringBuilder();
        builder.append("print(\"");
        int index = 0;
        while (index < toDisplay.length()) {
            char ch = toDisplay.charAt(index);
            switch (ch) {
                case '\"': {
                    builder.append("\\\"");
                    break;
                }
                case '\\': {
                    builder.append("\\\\");
                    break;
                }
                default: {
                    builder.append(ch);
                }
            }
            ++index;
        }
        builder.append("\")");
        return builder.toString();
    }

    @Override
    public String getProgram(String ... statements) {
        StringBuilder builder = new StringBuilder();
        int index = 0;
        while (index < statements.length) {
            builder.append(statements[index]);
            builder.append(";");
            ++index;
        }
        return builder.toString();
    }
}

