/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.script;

import java.io.Reader;
import java.io.StringReader;
import javax.script.AbstractScriptEngine;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.orcs.core.internal.script.OrcsScriptCompiler;
import org.eclipse.osee.orcs.core.internal.script.OrcsScriptEngineFactory;

public class OrcsScriptEngine
extends AbstractScriptEngine
implements Compilable {
    private final OrcsScriptCompiler compiler;
    private ScriptEngineFactory factory;

    public OrcsScriptEngine(OrcsScriptCompiler compiler) {
        this.compiler = compiler;
    }

    public void setEngineFactory(ScriptEngineFactory factory) {
        this.factory = factory;
    }

    private OrcsScriptCompiler getCompiler() {
        return this.compiler;
    }

    @Override
    public ScriptEngineFactory getFactory() {
        return this.factory != null ? this.factory : new OrcsScriptEngineFactory(this.compiler);
    }

    @Override
    public Bindings createBindings() {
        return new SimpleBindings();
    }

    @Override
    public Object eval(String script, ScriptContext context) throws ScriptException {
        if (script == null) {
            throw new NullPointerException("script was null");
        }
        return this.eval((Reader)new StringReader(script), context);
    }

    @Override
    public CompiledScript compile(String script) throws ScriptException {
        return this.compile(new StringReader(script));
    }

    @Override
    public Object eval(Reader reader, ScriptContext context) throws ScriptException {
        String fileName = (String)context.getAttribute("javax.script.filename", 100);
        if (!Strings.isValid((String)fileName)) {
            fileName = "<Unknown Source>";
        }
        OrcsScriptCompiler runtime = this.getCompiler();
        OrcsScriptCompiler.OrcsCompiledScript script = runtime.compileReader(reader, fileName);
        return script.eval(context);
    }

    @Override
    public CompiledScript compile(Reader reader) throws ScriptException {
        String fileName = (String)this.get("javax.script.filename");
        if (!Strings.isValid((String)fileName)) {
            fileName = "<Unknown Source>";
        }
        OrcsScriptCompiler runtime = this.getCompiler();
        OrcsScriptCompiler.OrcsCompiledScript script = runtime.compileReader(reader, fileName);
        return OrcsScriptEngine.newCompiledScript(this, script);
    }

    @Override
    protected ScriptContext getScriptContext(Bindings nn) {
        return super.getScriptContext(nn);
    }

    private static CompiledScript newCompiledScript(final ScriptEngine engine, final OrcsScriptCompiler.OrcsCompiledScript script) {
        return new CompiledScript(){

            @Override
            public Object eval(ScriptContext context) throws ScriptException {
                return script.eval(context);
            }

            @Override
            public ScriptEngine getEngine() {
                return engine;
            }
        };
    }
}

