/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.relation.order;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.io.Closeable;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.enums.RelationSide;
import org.eclipse.osee.framework.core.enums.RelationSorter;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.orcs.core.internal.relation.order.HasOrderData;
import org.eclipse.osee.orcs.core.internal.relation.order.OrderData;
import org.eclipse.osee.orcs.data.RelationTypes;

public class OrderParser {
    private static final String ROOT_ELEMENT = "OrderList";
    private static final String START_TAG = "Order";
    private static final String RELATION_TYPE_TAG = "relType";
    private static final String ORDER_TYPE_TAG = "orderType";
    private static final String SIDE_TAG = "side";
    private static final String LIST_TAG = "list";
    private static final ThreadLocal<XMLInputFactory> inputFactory = new ThreadLocal<XMLInputFactory>(){

        @Override
        protected XMLInputFactory initialValue() {
            return XMLInputFactory.newInstance();
        }
    };
    private static final ThreadLocal<XMLOutputFactory> outputFactory = new ThreadLocal<XMLOutputFactory>(){

        @Override
        protected XMLOutputFactory initialValue() {
            return XMLOutputFactory.newInstance();
        }
    };
    private final RelationTypes relationCache;

    public OrderParser(RelationTypes relationCache) {
        this.relationCache = relationCache;
    }

    public void loadFromXml(HasOrderData hasOrderData, String rawData) throws OseeCoreException {
        Conditions.checkNotNull((Object)hasOrderData, (String)"orderData");
        if (Strings.isValid((String)rawData) && rawData.trim().length() > 0) {
            StringReader reader = new StringReader(rawData);
            try {
                try {
                    XMLStreamReader streamReader = inputFactory.get().createXMLStreamReader(reader);
                    while (streamReader.hasNext()) {
                        this.process(streamReader, hasOrderData);
                        streamReader.next();
                    }
                }
                catch (XMLStreamException ex) {
                    OseeCoreException.wrapAndThrow((Throwable)ex);
                    Lib.close((Closeable)reader);
                }
            }
            finally {
                Lib.close((Closeable)reader);
            }
        }
    }

    private void process(XMLStreamReader reader, HasOrderData hasOrderData) throws OseeCoreException {
        int eventType = reader.getEventType();
        switch (eventType) {
            case 1: {
                String localName = reader.getLocalName();
                String uri = reader.getNamespaceURI();
                if (!START_TAG.equals(localName)) break;
                final String relationTypeName = reader.getAttributeValue(uri, RELATION_TYPE_TAG);
                String orderType = reader.getAttributeValue(uri, ORDER_TYPE_TAG);
                String relationSide = reader.getAttributeValue(uri, SIDE_TAG);
                String rawList = reader.getAttributeValue(uri, LIST_TAG);
                if (relationTypeName == null || orderType == null || relationSide == null) break;
                List<String> list = Collections.emptyList();
                if (rawList != null) {
                    list = new ArrayList();
                    StringTokenizer tokenizer = new StringTokenizer(rawList, ",");
                    while (tokenizer.hasMoreTokens()) {
                        list.add(tokenizer.nextToken());
                    }
                }
                RelationTypeToken type = (RelationTypeToken)Iterables.find((Iterable)this.relationCache.getAll(), (Predicate)new Predicate<RelationTypeToken>(){

                    public boolean apply(RelationTypeToken type) {
                        return type.getName().equalsIgnoreCase(relationTypeName);
                    }
                });
                RelationSide side = RelationSide.fromString((String)relationSide);
                RelationTypeSide typeSide = RelationTypeSide.create((RelationTypeToken)type, (RelationSide)side);
                OrderData orderData = new OrderData(RelationSorter.valueOfGuid((String)orderType), list);
                hasOrderData.add(typeSide, orderData);
                break;
            }
        }
    }

    public String toXml(HasOrderData hasOrderData) throws OseeCoreException {
        StringWriter writer;
        block17: {
            Conditions.checkNotNull((Object)hasOrderData, (String)"orderData");
            writer = new StringWriter();
            XMLStreamWriter xmlWriter = null;
            try {
                try {
                    xmlWriter = outputFactory.get().createXMLStreamWriter(writer);
                    if (hasOrderData.isEmpty()) {
                        xmlWriter.writeEmptyElement(ROOT_ELEMENT);
                    } else {
                        xmlWriter.writeStartElement(ROOT_ELEMENT);
                        for (Map.Entry entry : hasOrderData) {
                            this.writeEntry(xmlWriter, (RelationTypeSide)entry.getKey(), (OrderData)entry.getValue());
                        }
                        xmlWriter.writeEndElement();
                    }
                    xmlWriter.writeEndDocument();
                }
                catch (XMLStreamException ex) {
                    OseeCoreException.wrapAndThrow((Throwable)ex);
                    if (xmlWriter != null) {
                        try {
                            xmlWriter.close();
                        }
                        catch (XMLStreamException ex2) {
                            OseeCoreException.wrapAndThrow((Throwable)ex2);
                        }
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                if (xmlWriter != null) {
                    try {
                        xmlWriter.close();
                    }
                    catch (XMLStreamException ex) {
                        OseeCoreException.wrapAndThrow((Throwable)ex);
                    }
                }
                throw throwable;
            }
            if (xmlWriter != null) {
                try {
                    xmlWriter.close();
                }
                catch (XMLStreamException ex) {
                    OseeCoreException.wrapAndThrow((Throwable)ex);
                }
            }
        }
        return writer.toString();
    }

    private void writeEntry(XMLStreamWriter xmlWriter, RelationTypeSide typeAndSide, OrderData orderData) throws XMLStreamException {
        xmlWriter.writeEmptyElement(START_TAG);
        xmlWriter.writeAttribute(RELATION_TYPE_TAG, typeAndSide.getName());
        xmlWriter.writeAttribute(SIDE_TAG, typeAndSide.getSide().name());
        xmlWriter.writeAttribute(ORDER_TYPE_TAG, orderData.getSorterId().getGuid());
        List<String> guids = orderData.getOrderIds();
        if (!guids.isEmpty()) {
            xmlWriter.writeAttribute(LIST_TAG, org.eclipse.osee.framework.jdk.core.util.Collections.toString((String)",", guids));
        }
    }
}

