/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.relation.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.osee.framework.core.enums.LoadLevel;
import org.eclipse.osee.framework.core.enums.RelationSide;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.core.internal.graph.GraphData;
import org.eclipse.osee.orcs.core.internal.relation.Relation;
import org.eclipse.osee.orcs.core.internal.relation.RelationNode;
import org.eclipse.osee.orcs.core.internal.relation.RelationNodeLoader;
import org.eclipse.osee.orcs.core.internal.relation.RelationResolver;

public class RelationResolverImpl
implements RelationResolver {
    private final RelationNodeLoader loader;

    public RelationResolverImpl(RelationNodeLoader loader) {
        this.loader = loader;
    }

    @Override
    public <T extends RelationNode> List<T> resolve(OrcsSession session, GraphData graph, List<Relation> links, RelationSide ... sides) throws OseeCoreException {
        List<Object> toReturn = Collections.emptyList();
        if (!links.isEmpty()) {
            LinkedHashSet<Integer> toLoad = null;
            LinkedHashMap<Integer, RelationNode> items = new LinkedHashMap<Integer, RelationNode>();
            for (Relation relation : links) {
                RelationSide[] relationSideArray = sides;
                int n = sides.length;
                int n2 = 0;
                while (n2 < n) {
                    RelationSide side = relationSideArray[n2];
                    int localId = relation.getLocalIdForSide(side);
                    RelationNode node = (RelationNode)graph.getNode(localId);
                    if (node == null) {
                        if (toLoad == null) {
                            toLoad = new LinkedHashSet<Integer>();
                        }
                        toLoad.add(localId);
                    }
                    items.put(localId, node);
                    ++n2;
                }
            }
            if (toLoad != null && !toLoad.isEmpty()) {
                Iterable result = this.loader.loadNodes(session, graph, (Collection<Integer>)toLoad, LoadLevel.ALL);
                for (RelationNode item : result) {
                    items.put((Integer)item.getLocalId(), item);
                }
            }
            toReturn = this.toList(items.values());
        }
        return toReturn;
    }

    private <T> List<T> toList(Collection<T> values) {
        List<Object> list = values instanceof ArrayList ? (ArrayList)values : (values instanceof LinkedList ? (LinkedList)values : (values == null ? Collections.emptyList() : Lists.newLinkedList(values)));
        return list;
    }

    @Override
    public void resolve(OrcsSession session, GraphData graph, RelationNode node) throws OseeCoreException {
        this.loader.loadNodes(session, graph, Collections.singleton((Integer)node.getLocalId()), LoadLevel.RELATION_DATA);
    }
}

