/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.relation.impl;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.List;
import org.eclipse.osee.framework.core.data.HasLocalId;
import org.eclipse.osee.framework.core.data.IRelationType;
import org.eclipse.osee.framework.core.data.RelationTypeId;
import org.eclipse.osee.framework.core.enums.DeletionFlag;
import org.eclipse.osee.framework.core.enums.RelationSide;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.framework.jdk.core.type.ResultSets;
import org.eclipse.osee.orcs.core.internal.graph.GraphAdjacencies;
import org.eclipse.osee.orcs.core.internal.relation.Relation;
import org.eclipse.osee.orcs.core.internal.relation.RelationNode;
import org.eclipse.osee.orcs.core.internal.relation.RelationVisitor;
import org.eclipse.osee.orcs.core.internal.util.AbstractTypeCollection;
import org.eclipse.osee.orcs.core.internal.util.OrcsPredicates;

public class RelationNodeAdjacencies
extends AbstractTypeCollection<RelationTypeId, Relation, RelationTypeId, Relation>
implements GraphAdjacencies {
    @Override
    protected ResultSet<Relation> createResultSet(List<Relation> values) {
        return ResultSets.newResultSet(values);
    }

    @Override
    protected <T extends Relation> ResultSet<T> createResultSet(RelationTypeId type, List<T> values) {
        return ResultSets.newResultSet(values);
    }

    @Override
    protected Relation asMatcherData(Relation data) {
        return data;
    }

    @Override
    protected RelationTypeId getType(Relation data) throws OseeCoreException {
        return data.getRelationType();
    }

    public List<Relation> getList(IRelationType type, DeletionFlag includeDeleted) throws OseeCoreException {
        Predicate deletionFlagEquals = OrcsPredicates.deletionFlagEquals(includeDeleted);
        return this.getListByFilter(type, deletionFlagEquals);
    }

    public List<Relation> getList(RelationTypeId relationType, DeletionFlag includeDeleted, HasLocalId<Integer> localId, RelationSide side) throws OseeCoreException {
        Predicate deletionFlagEquals = OrcsPredicates.deletionFlagEquals(includeDeleted);
        Predicate<Relation> relIdOnSide = OrcsPredicates.nodeIdOnSideEquals(localId, side);
        Predicate matcher = Predicates.and(deletionFlagEquals, relIdOnSide);
        return this.getListByFilter(relationType, matcher);
    }

    public ResultSet<Relation> getResultSet(IRelationType type, DeletionFlag includeDeleted) throws OseeCoreException {
        Predicate deletionFlagEquals = OrcsPredicates.deletionFlagEquals(includeDeleted);
        return this.getSetByFilter(type, deletionFlagEquals);
    }

    public ResultSet<Relation> getResultSet(IRelationType type, DeletionFlag includeDeleted, HasLocalId<Integer> localId, RelationSide side) throws OseeCoreException {
        Predicate deletionFlagEquals = OrcsPredicates.deletionFlagEquals(includeDeleted);
        Predicate<Relation> relIdOnSide = OrcsPredicates.nodeIdOnSideEquals(localId, side);
        Predicate matcher = Predicates.and(deletionFlagEquals, relIdOnSide);
        return this.getSetByFilter(type, matcher);
    }

    public Relation getRelation(RelationNode aNode, RelationTypeId type, RelationNode bNode, DeletionFlag excludeDeleted) throws OseeCoreException {
        Predicate<Relation> nodeMatcher = OrcsPredicates.nodeIdsEquals(aNode, bNode);
        Predicate deletionFlagEquals = OrcsPredicates.deletionFlagEquals(excludeDeleted);
        Predicate matcher = Predicates.and(deletionFlagEquals, nodeMatcher);
        List listByFilter = this.getListByFilter(type, matcher);
        return listByFilter.isEmpty() ? null : (Relation)listByFilter.get(0);
    }

    public Relation getRelation(int artIdA, RelationTypeId relationType, int artIdB) throws OseeCoreException {
        Predicate<Relation> nodeMatcher = OrcsPredicates.nodeIdsEquals(artIdA, artIdB);
        List listByFilter = this.getListByFilter(relationType, nodeMatcher);
        return listByFilter.isEmpty() ? null : (Relation)listByFilter.get(0);
    }

    public void accept(RelationVisitor visitor) throws OseeCoreException {
        for (Relation relation : this.getAll()) {
            visitor.visit(relation);
        }
    }
}

