/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.relation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.osee.framework.core.data.IArtifactType;
import org.eclipse.osee.framework.core.data.IRelationType;
import org.eclipse.osee.framework.core.data.RelationTypeId;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.enums.RelationSide;
import org.eclipse.osee.framework.core.enums.RelationTypeMultiplicity;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.orcs.core.internal.relation.RelationNode;
import org.eclipse.osee.orcs.core.internal.util.MultiplicityState;
import org.eclipse.osee.orcs.data.RelationTypes;

public class RelationTypeValidity {
    private final RelationTypes relationTypes;

    public RelationTypeValidity(RelationTypes relationTypes) {
        this.relationTypes = relationTypes;
    }

    public void checkRelationTypeMultiplicity(RelationTypeToken type, RelationNode node, RelationSide side, int count) throws OseeCoreException {
        MultiplicityState state = this.getRelationMultiplicityState(type, side, count);
        switch (state) {
            case MAX_VIOLATION: {
                throw new OseeStateException("Relation type [%s] on [%s] exceeds max occurrence rule on [%s]", new Object[]{type, side, node.getExceptionString()});
            }
            case MIN_VIOLATION: {
                throw new OseeStateException("Relation type [%s] on [%s] is less than min occurrence rule on [%s]", new Object[]{type, side, node.getExceptionString()});
            }
        }
    }

    public void checkRelationTypeValid(RelationTypeId type, RelationNode node, RelationSide side) throws OseeCoreException {
        Conditions.checkNotNull((Object)type, (String)"type");
        Conditions.checkNotNull((Object)node, (String)"node");
        Conditions.checkNotNull((Object)side, (String)"relationSide");
        IArtifactType artifactType = node.getArtifactType();
        boolean isValid = this.isRelationTypeValid(type, artifactType, side);
        if (!isValid) {
            throw new OseeArgumentException("Relation validity error for [%s] - ArtifactType [%s] does not belong on side [%s] of relation [%s] - only items of type [%s] are allowed", new Object[]{node.getExceptionString(), artifactType, side.name(), type, this.relationTypes.getArtifactType(type, side)});
        }
    }

    public int getMaximumRelationsAllowed(RelationTypeId type, IArtifactType artifactType, RelationSide side) throws OseeCoreException {
        Conditions.checkNotNull((Object)type, (String)"relationType");
        Conditions.checkNotNull((Object)artifactType, (String)"artifactType");
        Conditions.checkNotNull((Object)side, (String)"relationSide");
        this.checkTypeExists(type);
        int toReturn = 0;
        if (this.relationTypes.isArtifactTypeAllowed(type, side, artifactType)) {
            toReturn = this.relationTypes.getMultiplicity(type).getLimit(side);
        }
        return toReturn;
    }

    public MultiplicityState getRelationMultiplicityState(RelationTypeToken type, RelationSide side, int count) throws OseeCoreException {
        Conditions.checkNotNull((Object)type, (String)"type");
        Conditions.checkNotNull((Object)side, (String)"relationSide");
        this.checkTypeExists((RelationTypeId)type);
        RelationTypeMultiplicity multiplicity = this.relationTypes.getMultiplicity((RelationTypeId)type);
        MultiplicityState toReturn = MultiplicityState.IS_VALID;
        int limit = multiplicity.getLimit(side);
        if (count > limit) {
            toReturn = MultiplicityState.MAX_VIOLATION;
        }
        return toReturn;
    }

    public boolean isRelationTypeValid(RelationTypeId relationType, IArtifactType artifactType, RelationSide relationSide) throws OseeCoreException {
        this.checkTypeExists(relationType);
        Conditions.checkNotNull((Object)artifactType, (String)"artifactType");
        Conditions.checkNotNull((Object)relationSide, (String)"relationSide");
        return this.getRelationSideMax(relationType, artifactType, relationSide) > 0;
    }

    public List<RelationTypeId> getValidRelationTypes(IArtifactType artifactType) throws OseeCoreException {
        Conditions.checkNotNull((Object)artifactType, (String)"artifactType");
        Collection types = this.relationTypes.getAll();
        ArrayList<RelationTypeId> toReturn = new ArrayList<RelationTypeId>();
        for (IRelationType relationType : types) {
            if (!this.isTypeAllowed(artifactType, relationType)) continue;
            toReturn.add((RelationTypeId)relationType);
        }
        return toReturn;
    }

    private boolean isTypeAllowed(IArtifactType artifactType, IRelationType relationType) throws OseeCoreException {
        boolean result = false;
        RelationSide[] relationSideArray = RelationSide.values();
        int n = relationSideArray.length;
        int n2 = 0;
        while (n2 < n) {
            RelationSide side = relationSideArray[n2];
            int sideMax = this.getRelationSideMax((RelationTypeId)relationType, artifactType, side);
            if (sideMax > 0) {
                result = true;
                break;
            }
            ++n2;
        }
        return result;
    }

    private void checkTypeExists(RelationTypeId type) throws OseeCoreException {
        boolean exists = this.relationTypes.exists((Id)type);
        Conditions.checkExpressionFailOnTrue((!exists ? 1 : 0) != 0, (String)"relationType [%s] does not exist", (Object[])new Object[]{type});
    }

    private int getRelationSideMax(RelationTypeId relationType, IArtifactType artifactType, RelationSide relationSide) throws OseeCoreException {
        int toReturn = 0;
        if (this.relationTypes.isArtifactTypeAllowed(relationType, relationSide, artifactType)) {
            toReturn = this.relationTypes.getMultiplicity(relationType).getLimit(relationSide);
        }
        return toReturn;
    }
}

