/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.relation;

import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.RelationTypeId;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.orcs.core.ds.RelationData;
import org.eclipse.osee.orcs.core.ds.RelationDataFactory;
import org.eclipse.osee.orcs.core.internal.relation.Relation;
import org.eclipse.osee.orcs.core.internal.relation.RelationNode;
import org.eclipse.osee.orcs.core.internal.relation.impl.RelationNodeAdjacencies;
import org.eclipse.osee.orcs.core.internal.util.OrcsConditions;
import org.eclipse.osee.orcs.data.RelationTypes;

public class RelationFactory {
    private final RelationTypes relationTypes;
    private final RelationDataFactory relationDataFactory;

    public RelationFactory(RelationTypes relationTypes, RelationDataFactory relationDataFactory) {
        this.relationTypes = relationTypes;
        this.relationDataFactory = relationDataFactory;
    }

    public RelationNodeAdjacencies createRelationContainer() {
        return new RelationNodeAdjacencies();
    }

    public Relation createRelation(RelationData data) {
        return new Relation(this.relationTypes, data);
    }

    public Relation createRelation(RelationNode aNode, RelationTypeId type, RelationNode bNode) throws OseeCoreException {
        return this.createRelation(aNode, type, bNode, "");
    }

    public Relation createRelation(RelationNode aNode, RelationTypeId type, RelationNode bNode, String rationale) throws OseeCoreException {
        OrcsConditions.checkBranch(aNode, bNode);
        OrcsConditions.checkRelateSelf(aNode, bNode);
        RelationData data = this.relationDataFactory.createRelationData(type, aNode.getBranch(), aNode, bNode, rationale);
        return this.createRelation(data);
    }

    public Relation clone(Relation src) throws OseeCoreException {
        RelationData data = this.relationDataFactory.clone(src.getOrcsData());
        return this.createRelation(data);
    }

    public Relation introduce(BranchId branch, RelationData data) {
        RelationData source = this.relationDataFactory.introduce(branch, data);
        return this.createRelation(source);
    }
}

