/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.relation;

import org.eclipse.osee.framework.core.data.ApplicabilityId;
import org.eclipse.osee.framework.core.data.IRelationType;
import org.eclipse.osee.framework.core.data.RelationTypeId;
import org.eclipse.osee.framework.core.enums.ModificationType;
import org.eclipse.osee.framework.core.enums.RelationSide;
import org.eclipse.osee.orcs.core.ds.HasOrcsData;
import org.eclipse.osee.orcs.core.ds.RelationData;
import org.eclipse.osee.orcs.core.internal.util.OrcsWriteable;
import org.eclipse.osee.orcs.data.RelationReadable;
import org.eclipse.osee.orcs.data.RelationTypes;

public class Relation
implements RelationReadable,
HasOrcsData<RelationData>,
OrcsWriteable {
    private final RelationTypes relationTypes;
    private RelationData relationData;

    public Relation(RelationTypes relationTypes, RelationData relationData) {
        this.relationTypes = relationTypes;
        this.relationData = relationData;
    }

    @Override
    public RelationData getOrcsData() {
        return this.relationData;
    }

    @Override
    public void setOrcsData(RelationData data) {
        this.relationData = data;
    }

    public RelationTypeId getRelationType() {
        return (RelationTypeId)this.relationTypes.get(Long.valueOf(this.getOrcsData().getTypeUuid()));
    }

    public ModificationType getModificationType() {
        return this.getOrcsData().getModType();
    }

    public boolean isDeleted() {
        return this.getModificationType().isDeleted();
    }

    public void delete() {
        this.markAsChanged(ModificationType.DELETED);
    }

    public boolean isDirty() {
        return this.getOrcsData().isDirty();
    }

    public void clearDirty() {
        this.setDirtyFlag(false);
    }

    public void setDirty() {
        this.setDirtyFlag(true);
    }

    private void setDirtyFlag(boolean dirty) {
        this.getOrcsData().calculateDirtyState(dirty);
    }

    public String getRationale() {
        return this.getOrcsData().getRationale();
    }

    public boolean isOfType(IRelationType oseeType) {
        return this.getRelationType().equals(oseeType);
    }

    public void setRationale(String rationale) {
        String toSet = rationale;
        if (toSet == null) {
            toSet = "";
        }
        if (!toSet.equals(this.getOrcsData().getRationale())) {
            this.getOrcsData().setRationale(rationale);
            this.markAsChanged(ModificationType.MODIFIED);
        }
    }

    public void setApplicabilityId(ApplicabilityId applicId) {
        this.getOrcsData().setApplicabilityId(applicId);
    }

    protected void markAsChanged(ModificationType modificationType) {
        ModificationType modType = this.computeModType(this.getOrcsData().getModType(), modificationType);
        this.getOrcsData().setModType(modType);
        this.setDirty();
    }

    private ModificationType computeModType(ModificationType original, ModificationType newModType) {
        ModificationType toReturn = original;
        if (original != ModificationType.DELETED || original != ModificationType.ARTIFACT_DELETED) {
            toReturn = newModType;
        }
        return toReturn;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.relationData == null ? 0 : this.relationData.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Relation other = (Relation)obj;
        return !(this.relationData == null ? other.relationData != null : !this.relationData.equals(other.relationData));
    }

    public Integer getLocalIdForSide(RelationSide side) {
        return this.getOrcsData().getArtIdOn(side);
    }

    public boolean isDeleteAllowed() {
        return !this.isDeleted();
    }

    public void unDelete() {
        this.getOrcsData().setModType(ModificationType.UNDELETED);
    }

    public String toString() {
        return "Relation [relationData=" + this.relationData + ", isDirty=" + this.getOrcsData().isDirty() + "]";
    }

    public Long getId() {
        return (long)((Integer)this.getOrcsData().getLocalId());
    }

    public long getGammaId() {
        return this.getOrcsData().getVersion().getGammaId();
    }

    public int getArtIdA() {
        return this.getOrcsData().getArtIdA();
    }

    public int getArtIdB() {
        return this.getOrcsData().getArtIdB();
    }
}

