/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.proxy.impl;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.framework.jdk.core.type.ResultSets;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.core.internal.artifact.Artifact;
import org.eclipse.osee.orcs.core.internal.attribute.Attribute;
import org.eclipse.osee.orcs.core.internal.proxy.ExternalArtifactManager;
import org.eclipse.osee.orcs.core.internal.proxy.impl.ArtifactReadOnlyImpl;
import org.eclipse.osee.orcs.core.internal.proxy.impl.AttributeReadOnlyImpl;
import org.eclipse.osee.orcs.core.internal.relation.RelationManager;
import org.eclipse.osee.orcs.core.internal.relation.RelationNode;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.data.AttributeReadable;

public class ExternalArtifactManagerImpl
implements ExternalArtifactManager {
    private final Function<ArtifactReadable, Artifact> readableToArtifact;
    private final RelationManager relationManager;

    public ExternalArtifactManagerImpl(RelationManager relationManager) {
        this.relationManager = relationManager;
        this.readableToArtifact = new ReadableToArtifactFunction();
    }

    @Override
    public Artifact asInternalArtifact(ArtifactReadable external) {
        return external == null ? null : (Artifact)((ArtifactReadOnlyImpl)external).getProxiedObject();
    }

    @Override
    public ArtifactReadable asExternalArtifact(OrcsSession session, Artifact artifact) {
        return artifact == null ? null : new ArtifactReadOnlyImpl(this, this.relationManager, session, artifact);
    }

    @Override
    public <T> AttributeReadable<T> asExternalAttribute(OrcsSession session, Attribute<T> attribute) {
        return attribute == null ? null : new AttributeReadOnlyImpl<T>((ExternalArtifactManager)this, session, attribute);
    }

    @Override
    public ResultSet<? extends RelationNode> asInternalArtifacts(Iterable<? extends ArtifactReadable> externals) {
        Iterable transformed = Iterables.transform(externals, this.readableToArtifact);
        return ResultSets.newResultSet((Iterable)transformed);
    }

    @Override
    public ResultSet<ArtifactReadable> asExternalArtifacts(final OrcsSession session, Iterable<? extends Artifact> artifacts) {
        Iterable transformed = Iterables.transform(artifacts, (Function)new Function<Artifact, ArtifactReadable>(){

            public ArtifactReadable apply(Artifact internal) {
                return ExternalArtifactManagerImpl.this.asExternalArtifact(session, internal);
            }
        });
        return ResultSets.newResultSet((Iterable)transformed);
    }

    @Override
    public <T> ResultSet<AttributeReadable<T>> asExternalAttributes(final OrcsSession session, Iterable<? extends Attribute<T>> attributes) {
        Iterable transformed = Iterables.transform(attributes, (Function)new Function<Attribute<T>, AttributeReadable<T>>(){

            public AttributeReadable<T> apply(Attribute<T> internal) {
                return ExternalArtifactManagerImpl.this.asExternalAttribute(session, internal);
            }
        });
        return ResultSets.newResultSet((Iterable)transformed);
    }

    public static interface ProxyProvider {
        public Artifact getInternalArtifact(ArtifactReadable var1);
    }

    private final class ReadableToArtifactFunction
    implements Function<ArtifactReadable, Artifact> {
        private ReadableToArtifactFunction() {
        }

        public Artifact apply(ArtifactReadable external) {
            return ExternalArtifactManagerImpl.this.asInternalArtifact(external);
        }
    }
}

