/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.proxy.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.IArtifactType;
import org.eclipse.osee.framework.core.data.RelationTypeId;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.core.enums.DeletionFlag;
import org.eclipse.osee.framework.core.enums.ModificationType;
import org.eclipse.osee.framework.core.enums.RelationSide;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.Pair;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.framework.jdk.core.type.ResultSetList;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.core.ds.ArtifactData;
import org.eclipse.osee.orcs.core.internal.artifact.Artifact;
import org.eclipse.osee.orcs.core.internal.attribute.Attribute;
import org.eclipse.osee.orcs.core.internal.proxy.ExternalArtifactManager;
import org.eclipse.osee.orcs.core.internal.proxy.impl.AbstractProxied;
import org.eclipse.osee.orcs.core.internal.relation.Relation;
import org.eclipse.osee.orcs.core.internal.relation.RelationManager;
import org.eclipse.osee.orcs.core.internal.relation.RelationNode;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.data.AttributeReadable;
import org.eclipse.osee.orcs.data.RelationReadable;

public class ArtifactReadOnlyImpl
extends AbstractProxied<Artifact>
implements ArtifactReadable {
    private final RelationManager relationManager;

    public ArtifactReadOnlyImpl(ExternalArtifactManager proxyManager, RelationManager relationManager, OrcsSession session, Artifact proxiedObject) {
        super(proxyManager, session, proxiedObject);
        this.relationManager = relationManager;
    }

    private RelationManager getRelationManager() {
        return this.relationManager;
    }

    public String getGuid() {
        return (String)((Artifact)this.getProxiedObject()).getGuid();
    }

    public String getName() {
        return ((Artifact)this.getProxiedObject()).getName();
    }

    public boolean matches(Id ... identities) {
        return ((Artifact)this.getProxiedObject()).matches(identities);
    }

    public BranchId getBranch() {
        return ((Artifact)this.getProxiedObject()).getBranch();
    }

    public TransactionId getTransaction() {
        return ((Artifact)this.getProxiedObject()).getTransaction();
    }

    public TransactionId getLastModifiedTransaction() {
        return ((Artifact)this.getProxiedObject()).getLastModifiedTransaction();
    }

    public IArtifactType getArtifactType() throws OseeCoreException {
        return ((Artifact)this.getProxiedObject()).getArtifactType();
    }

    public boolean isOfType(ArtifactTypeId ... otherTypes) throws OseeCoreException {
        return ((Artifact)this.getProxiedObject()).isOfType(otherTypes);
    }

    public int getAttributeCount(AttributeTypeId type) throws OseeCoreException {
        return ((Artifact)this.getProxiedObject()).getAttributeCount(type);
    }

    public int getAttributeCount(AttributeTypeId type, DeletionFlag deletionFlag) throws OseeCoreException {
        return ((Artifact)this.getProxiedObject()).getAttributeCount(type, deletionFlag);
    }

    public boolean isAttributeTypeValid(AttributeTypeId attributeType) throws OseeCoreException {
        return ((Artifact)this.getProxiedObject()).isAttributeTypeValid(attributeType);
    }

    public Collection<AttributeTypeToken> getValidAttributeTypes() throws OseeCoreException {
        return ((Artifact)this.getProxiedObject()).getValidAttributeTypes();
    }

    public Collection<AttributeTypeToken> getExistingAttributeTypes() throws OseeCoreException {
        return ((Artifact)this.getProxiedObject()).getExistingAttributeTypes();
    }

    public <T> T getSoleAttributeValue(AttributeTypeId attributeType) {
        return (T)((Artifact)this.getProxiedObject()).getSoleAttributeValue(attributeType);
    }

    public <T> T getSoleAttributeValue(AttributeTypeId attributeType, DeletionFlag flag, T defaultValue) {
        return (T)((Artifact)this.getProxiedObject()).getSoleAttributeValue(attributeType, flag, defaultValue);
    }

    public <T> T getSoleAttributeValue(AttributeTypeId attributeType, T defaultValue) throws OseeCoreException {
        return (T)((Artifact)this.getProxiedObject()).getSoleAttributeValue(attributeType, defaultValue);
    }

    public String getSoleAttributeAsString(AttributeTypeId attributeType) throws OseeCoreException {
        return ((Artifact)this.getProxiedObject()).getSoleAttributeAsString(attributeType);
    }

    public String getSoleAttributeAsString(AttributeTypeId attributeType, String defaultValue) throws OseeCoreException {
        return ((Artifact)this.getProxiedObject()).getSoleAttributeAsString(attributeType, defaultValue);
    }

    public Long getSoleAttributeId(AttributeTypeId attributeType) {
        return (long)((Artifact)this.getProxiedObject()).getSoleAttribute(attributeType).getLocalId();
    }

    public <T> List<T> getAttributeValues(AttributeTypeId attributeType) throws OseeCoreException {
        return ((Artifact)this.getProxiedObject()).getAttributeValues(attributeType);
    }

    public String getAttributeValuesAsString(AttributeTypeId attributeType) {
        List attributes = ((Artifact)this.getProxiedObject()).getAttributes(attributeType);
        return Collections.toString((String)", ", (Iterable)attributes);
    }

    public ResultSet<? extends AttributeReadable<Object>> getAttributes() throws OseeCoreException {
        List attributes = ((Artifact)this.getProxiedObject()).getAttributes();
        return this.getProxyManager().asExternalAttributes(this.getSession(), attributes);
    }

    public <T> ResultSet<? extends AttributeReadable<T>> getAttributes(AttributeTypeId attributeType) throws OseeCoreException {
        List attributes = ((Artifact)this.getProxiedObject()).getAttributes(attributeType);
        return this.getProxyManager().asExternalAttributes(this.getSession(), attributes);
    }

    public ResultSet<? extends AttributeReadable<Object>> getAttributes(DeletionFlag deletionFlag) throws OseeCoreException {
        List attributes = ((Artifact)this.getProxiedObject()).getAttributes(deletionFlag);
        return this.getProxyManager().asExternalAttributes(this.getSession(), attributes);
    }

    public <T> ResultSet<? extends AttributeReadable<T>> getAttributes(AttributeTypeId attributeType, DeletionFlag deletionFlag) throws OseeCoreException {
        List attributes = ((Artifact)this.getProxiedObject()).getAttributes(attributeType, deletionFlag);
        return this.getProxyManager().asExternalAttributes(this.getSession(), attributes);
    }

    public AttributeReadable<Object> getAttributeById(AttributeId attributeId) throws OseeCoreException {
        Attribute attribute = ((Artifact)this.getProxiedObject()).getAttributeById(attributeId.getId().intValue());
        return this.getProxyManager().asExternalAttribute(this.getSession(), attribute);
    }

    public int getMaximumRelationAllowed(RelationTypeSide typeAndSide) throws OseeCoreException {
        RelationTypeToken type = typeAndSide.getRelationType();
        RelationSide side = this.whichSideAmIOn(typeAndSide);
        return this.getRelationManager().getMaximumRelationAllowed(this.getSession(), (RelationTypeId)type, (RelationNode)this.getProxiedObject(), side);
    }

    public Collection<RelationTypeId> getValidRelationTypes() throws OseeCoreException {
        return this.getRelationManager().getValidRelationTypes(this.getSession(), (RelationNode)this.getProxiedObject());
    }

    public Collection<RelationTypeId> getExistingRelationTypes() throws OseeCoreException {
        return this.getRelationManager().getExistingRelationTypes(this.getSession(), (RelationNode)this.getProxiedObject());
    }

    public ArtifactReadable getParent() throws OseeCoreException {
        Artifact parent = (Artifact)this.getRelationManager().getParent(this.getSession(), (RelationNode)this.getProxiedObject());
        return this.getProxyManager().asExternalArtifact(this.getSession(), parent);
    }

    public ResultSet<ArtifactReadable> getChildren() throws OseeCoreException {
        ResultSet children = this.getRelationManager().getChildren(this.getSession(), (RelationNode)this.getProxiedObject());
        return this.getProxyManager().asExternalArtifacts(this.getSession(), (Iterable<? extends Artifact>)children);
    }

    public List<ArtifactReadable> getDescendants() throws OseeCoreException {
        LinkedList<ArtifactReadable> descendants = new LinkedList<ArtifactReadable>();
        this.getDescendants(descendants);
        return descendants;
    }

    public void getDescendants(List<ArtifactReadable> descendants) throws OseeCoreException {
        for (ArtifactReadable child : this.getChildren()) {
            descendants.add(child);
            child.getDescendants(descendants);
        }
    }

    public List<ArtifactReadable> getAncestors() throws OseeCoreException {
        ArrayList<ArtifactReadable> ancestors = new ArrayList<ArtifactReadable>();
        ArtifactReadable parent = this.getParent();
        while (parent != null) {
            ancestors.add(parent);
            parent = parent.getParent();
        }
        return ancestors;
    }

    public ResultSet<ArtifactReadable> getRelated(RelationTypeSide typeAndSide) throws OseeCoreException {
        return this.getRelated(typeAndSide, DeletionFlag.EXCLUDE_DELETED);
    }

    public List<ArtifactReadable> getRelated(RelationTypeSide relationTypeSide, ArtifactTypeId artifactType) {
        ArrayList<ArtifactReadable> artifacts = new ArrayList<ArtifactReadable>();
        for (ArtifactReadable artifact : this.getRelated(relationTypeSide)) {
            if (!artifact.isOfType(new ArtifactTypeId[]{artifactType})) continue;
            artifacts.add(artifact);
        }
        return artifacts;
    }

    public ResultSet<RelationReadable> getRelations(RelationTypeSide typeAndSide) {
        return new ResultSetList(Collections.castAll(this.getRelationManager().getRelations(this.getSession(), (RelationNode)this.getProxiedObject(), DeletionFlag.EXCLUDE_DELETED)));
    }

    public ResultSet<ArtifactReadable> getRelated(RelationTypeSide typeAndSide, DeletionFlag deletionFlag) throws OseeCoreException {
        RelationTypeToken type = typeAndSide.getRelationType();
        RelationSide side = this.whichSideAmIOn(typeAndSide);
        ResultSet related = this.getRelationManager().getRelated(this.getSession(), (RelationTypeId)type, (RelationNode)this.getProxiedObject(), side, deletionFlag);
        return this.getProxyManager().asExternalArtifacts(this.getSession(), (Iterable<? extends Artifact>)related);
    }

    public int getRelatedCount(RelationTypeSide typeAndSide) throws OseeCoreException {
        RelationTypeToken type = typeAndSide.getRelationType();
        RelationSide side = this.whichSideAmIOn(typeAndSide);
        return this.getRelationManager().getRelatedCount(this.getSession(), (RelationTypeId)type, (RelationNode)this.getProxiedObject(), side);
    }

    public boolean areRelated(RelationTypeSide typeAndSide, ArtifactReadable readable) throws OseeCoreException {
        RelationTypeToken type = typeAndSide.getRelationType();
        Pair<RelationNode, RelationNode> nodes = this.asABNodes(typeAndSide.getSide(), readable);
        return this.getRelationManager().areRelated(this.getSession(), (RelationNode)nodes.getFirst(), (RelationTypeId)type, (RelationNode)nodes.getSecond());
    }

    public String getRationale(RelationTypeSide typeAndSide, ArtifactReadable readable) throws OseeCoreException {
        RelationTypeToken type = typeAndSide.getRelationType();
        Pair<RelationNode, RelationNode> nodes = this.asABNodes(typeAndSide.getSide(), readable);
        return this.getRelationManager().getRationale(this.getSession(), (RelationNode)nodes.getFirst(), (RelationTypeId)type, (RelationNode)nodes.getSecond());
    }

    private Pair<RelationNode, RelationNode> asABNodes(RelationSide side, ArtifactReadable readable) throws OseeCoreException {
        Artifact bNode;
        Artifact aNode;
        Artifact thisArtifact = (Artifact)this.getProxiedObject();
        Artifact otherArtifact = this.getProxyManager().asInternalArtifact(readable);
        if (RelationSide.SIDE_A == side) {
            aNode = otherArtifact;
            bNode = thisArtifact;
        } else {
            aNode = thisArtifact;
            bNode = otherArtifact;
        }
        return new Pair((Object)aNode, (Object)bNode);
    }

    private RelationSide whichSideAmIOn(RelationTypeSide typeAndSide) {
        return typeAndSide.getSide().oppositeSide();
    }

    public Long getId() {
        return ((Integer)((Artifact)this.getProxiedObject()).getLocalId()).longValue();
    }

    @Override
    public String toString() {
        return String.format("Artifact: Id [%s] Type [%s] Name [%s]", this.getIdString(), this.getArtifactType().getName(), this.getName());
    }

    public boolean isDeleted() {
        return ((Artifact)this.getProxiedObject()).isDeleted();
    }

    public ModificationType getModificationType() {
        return ((Artifact)this.getProxiedObject()).getModificationType();
    }

    public Collection<Long> getChildrentIds() {
        return this.getRelatedIds(CoreRelationTypes.Default_Hierarchical__Child);
    }

    public Collection<Long> getRelatedIds(RelationTypeSide relationTypeSide) {
        ArrayList<Long> childIds = new ArrayList<Long>();
        for (Relation relation : this.getRelationManager().getRelations(this.getSession(), (RelationNode)this.getProxiedObject(), DeletionFlag.EXCLUDE_DELETED)) {
            boolean thisOnCorrectSide;
            boolean relIsSideA = relationTypeSide.getSide().isSideA();
            boolean bl = thisOnCorrectSide = relIsSideA && relation.getArtIdB() == this.getId().intValue() || !relIsSideA && relation.getArtIdA() == this.getId().intValue();
            if (!thisOnCorrectSide || !relation.getRelationType().matches(new Id[]{relationTypeSide})) continue;
            childIds.add(Long.valueOf(relation.getArtIdB()));
        }
        return childIds;
    }

    public boolean isHistorical() {
        return ((ArtifactData)((Artifact)this.getProxiedObject()).getOrcsData()).getVersion().isHistorical();
    }
}

