/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.indexer.collector;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.osee.orcs.search.IndexerCollectorAdapter;

public class TagCollectorImpl
extends IndexerCollectorAdapter {
    private volatile Map<Integer, Throwable> tagErrors;
    private volatile Set<Integer> queryIds = Collections.synchronizedSet(new HashSet());
    private volatile boolean wasProcessed = false;
    private volatile int expectedTotal;
    private volatile int queryCount = 0;
    private volatile int attributeCount = 0;

    public TagCollectorImpl() {
        this.tagErrors = Collections.synchronizedMap(new HashMap());
    }

    public boolean wasProcessed() {
        return this.wasProcessed;
    }

    public boolean hasErrors() {
        return this.tagErrors.size() > 0;
    }

    public int getAttributeCount() {
        return this.attributeCount;
    }

    public int getQueryCount() {
        return this.queryCount;
    }

    public Map<Integer, Throwable> getTagErrors() {
        return this.tagErrors;
    }

    public void onIndexTaskTotalToProcess(int totalQueries) {
        this.expectedTotal = totalQueries;
    }

    public synchronized void onIndexTaskError(int queryId, Throwable throwable) {
        this.tagErrors.put(queryId, throwable);
        this.wasProcessed = true;
        ((Object)((Object)this)).notify();
    }

    public synchronized void onIndexTaskSubmit(int queryId) {
        ++this.queryCount;
        this.queryIds.add(queryId);
    }

    public void onIndexItemComplete(int queryId, long gammaId, int totalTags, long processingTime) {
        if (this.queryIds.contains(queryId)) {
            ++this.attributeCount;
        }
    }

    public synchronized void onIndexTaskComplete(int queryId, long waitTime, long processingTime) {
        if (this.queryIds.contains(queryId)) {
            this.queryIds.remove(queryId);
            if (this.queryIds.isEmpty() && this.queryCount == this.expectedTotal) {
                this.wasProcessed = true;
                ((Object)((Object)this)).notify();
            }
        }
    }
}

