/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.indexer;

import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import org.eclipse.osee.executor.admin.CancellableCallable;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.core.ds.QueryEngineIndexer;
import org.eclipse.osee.orcs.data.AttributeTypes;
import org.eclipse.osee.orcs.data.BranchReadable;
import org.eclipse.osee.orcs.search.IndexerCollector;
import org.eclipse.osee.orcs.search.QueryIndexer;

public class QueryIndexerImpl
implements QueryIndexer {
    private final OrcsSession session;
    private final QueryEngineIndexer engineIndexer;
    private final AttributeTypes attributeTypes;

    public QueryIndexerImpl(OrcsSession session, QueryEngineIndexer engineIndexer, AttributeTypes attributeTypes) {
        this.session = session;
        this.engineIndexer = engineIndexer;
        this.attributeTypes = attributeTypes;
    }

    public CancellableCallable<Integer> indexAllFromQueue(IndexerCollector ... collector) {
        return this.engineIndexer.indexAllFromQueue(this.session, this.attributeTypes, collector);
    }

    public CancellableCallable<Integer> indexBranches(final Set<BranchReadable> branches, final boolean indexOnlyMissing, final IndexerCollector ... collector) {
        return new CancellableCallable<Integer>(){

            public Integer call() throws Exception {
                return (Integer)QueryIndexerImpl.this.engineIndexer.indexBranches(QueryIndexerImpl.this.session, QueryIndexerImpl.this.attributeTypes, QueryIndexerImpl.this.attributeTypes.getAllTaggable(), branches, indexOnlyMissing, collector).call();
            }
        };
    }

    public CancellableCallable<List<Future<?>>> indexResources(Iterable<Long> gammaIds, IndexerCollector ... collector) {
        return this.engineIndexer.indexResources(this.session, this.attributeTypes, gammaIds, collector);
    }

    public void indexAttrTypeIds(Iterable<Long> attrTypeIds) {
        this.engineIndexer.indexAttrTypeIds(this.session, this.attributeTypes, attrTypeIds);
    }

    public CancellableCallable<Integer> deleteIndexByQueryId(int queueId) {
        return this.engineIndexer.deleteIndexByQueryId(this.session, queueId);
    }

    public CancellableCallable<Integer> purgeAllIndexes() {
        return this.engineIndexer.purgeAllIndexes(this.session);
    }
}

