/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.graph.impl;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.HasLocalId;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.core.internal.graph.GraphAdjacencies;
import org.eclipse.osee.orcs.core.internal.graph.GraphData;
import org.eclipse.osee.orcs.core.internal.graph.GraphNode;

public class GraphDataImpl
implements GraphData {
    private final Map<Integer, GraphNode> nodesById = new ConcurrentHashMap<Integer, GraphNode>();
    private final Map<Integer, GraphAdjacencies> adjacenciesById = new ConcurrentHashMap<Integer, GraphAdjacencies>();
    private final BranchId branch;
    private final TransactionId txId;
    private final OrcsSession orcsSession;

    public GraphDataImpl(OrcsSession session, BranchId branch, TransactionId txId) {
        this.orcsSession = session;
        this.branch = branch;
        this.txId = txId;
    }

    public TransactionId getTransaction() {
        return this.txId;
    }

    @Override
    public <T extends GraphNode> T getNode(HasLocalId<Integer> data) {
        return this.getNode((Integer)data.getLocalId());
    }

    @Override
    public <T extends GraphNode> T getNode(Integer id) {
        return (T)this.nodesById.get(id);
    }

    @Override
    public void addNode(GraphNode node, boolean useBackingData) throws OseeCoreException {
        boolean sameBranches = this.getBranch().equals(node.getBranch());
        if (!sameBranches) {
            throw new OseeArgumentException("Invalid node added to graph. Graph[%s] Node[%s]", new Object[]{this, node.getExceptionString()});
        }
        GraphData oldGraph = node.getGraph();
        if (!this.equals(oldGraph) || useBackingData) {
            if (oldGraph != null) {
                oldGraph.removeNode(node);
            }
            this.nodesById.put((Integer)node.getLocalId(), node);
            node.setGraph(this);
        }
    }

    @Override
    public <T extends GraphNode> T removeNode(HasLocalId<Integer> node) {
        return this.removeNode((Integer)node.getLocalId());
    }

    @Override
    public <T extends GraphNode> T removeNode(Integer id) {
        GraphNode removed = this.nodesById.remove(id);
        this.removeAdjacencies(id);
        return (T)removed;
    }

    @Override
    public <T extends GraphAdjacencies> T getAdjacencies(HasLocalId<Integer> node) {
        return this.getAdjacencies((Integer)node.getLocalId());
    }

    @Override
    public <T extends GraphAdjacencies> T getAdjacencies(Integer id) {
        return (T)this.adjacenciesById.get(id);
    }

    @Override
    public void addAdjacencies(HasLocalId<Integer> node, GraphAdjacencies adjacencies) {
        this.addAdjacencies((Integer)node.getLocalId(), adjacencies);
    }

    @Override
    public void addAdjacencies(Integer id, GraphAdjacencies adjacencies) {
        this.adjacenciesById.put(id, adjacencies);
    }

    @Override
    public <T extends GraphAdjacencies> T removeAdjacencies(HasLocalId<Integer> node) {
        return this.removeAdjacencies((Integer)node.getLocalId());
    }

    @Override
    public <T extends GraphAdjacencies> T removeAdjacencies(Integer id) {
        return (T)this.adjacenciesById.remove(id);
    }

    public String toString() {
        return String.format("Graph - branch[%s] txId[%s] nodes[%s] adjacencies[%s]", this.getBranch(), this.getTransaction(), this.nodesById.size(), this.adjacenciesById.size());
    }

    public int hashCode() {
        int result = this.getBranch().hashCode();
        result = 31 * result + this.getTransaction().hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof GraphData)) {
            return false;
        }
        GraphData other = (GraphData)obj;
        if (!this.getBranch().equals(other.getBranch())) {
            return false;
        }
        return this.getTransaction() == other.getTransaction();
    }

    @Override
    public OrcsSession getSession() {
        return this.orcsSession;
    }

    public BranchId getBranch() {
        return this.branch;
    }
}

