/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.console;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import org.eclipse.osee.console.admin.Console;
import org.eclipse.osee.console.admin.ConsoleCommand;
import org.eclipse.osee.console.admin.ConsoleParameters;
import org.eclipse.osee.framework.core.data.IRelationType;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.OrcsTypes;
import org.eclipse.osee.orcs.data.RelationTypes;

public class PurgeRelationTypeCommand
implements ConsoleCommand {
    private OrcsApi orcsApi;

    public void setOrcsApi(OrcsApi orcsApi) {
        this.orcsApi = orcsApi;
    }

    public OrcsApi getOrcsApi() {
        return this.orcsApi;
    }

    public String getName() {
        return "purge_relation_type";
    }

    public String getDescription() {
        return "Purges relation type instances from datastore";
    }

    public String getUsage() {
        return "[force=<TRUE|FALSE>] types=<RELATION_TYPES,...>";
    }

    public Callable<?> createCallable(final Console console, final ConsoleParameters params) {
        final OrcsTypes orcsTypes = this.orcsApi.getOrcsTypes();
        return new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                boolean found;
                boolean forcePurge = params.getBoolean("force");
                String[] typesToPurge = params.getArray("types");
                console.writeln();
                console.writeln((Object)(!forcePurge ? "Relation Types" : "Purging relation types:"));
                Set<IRelationType> types = this.getTypes(typesToPurge);
                boolean bl = found = !types.isEmpty();
                if (forcePurge && found) {
                    orcsTypes.purgeRelationsByRelationType(types).call();
                }
                console.writeln((Object)(found && !forcePurge ? "To >DELETE Relation DATA!< add --force to confirm." : "Operation finished."));
                return null;
            }

            private Set<IRelationType> getTypes(String[] typesToPurge) throws OseeCoreException {
                RelationTypes relationTypes = orcsTypes.getRelationTypes();
                HashSet<IRelationType> toReturn = new HashSet<IRelationType>();
                String[] stringArray = typesToPurge;
                int n = typesToPurge.length;
                int n2 = 0;
                while (n2 < n) {
                    String uuid = stringArray[n2];
                    try {
                        Long typeId = Long.valueOf(uuid);
                        RelationTypeToken type = (RelationTypeToken)relationTypes.get(typeId);
                        console.writeln("Type [%s] found. Id: [%s]", new Object[]{type.getName(), type.getId()});
                        toReturn.add((IRelationType)type);
                    }
                    catch (OseeArgumentException ex) {
                        console.writeln("Type [0x%X] NOT found.", new Object[]{uuid});
                        console.writeln((Throwable)ex);
                    }
                    ++n2;
                }
                return toReturn;
            }
        };
    }
}

