/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.console;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.Callable;
import org.eclipse.osee.console.admin.Console;
import org.eclipse.osee.console.admin.ConsoleCommand;
import org.eclipse.osee.console.admin.ConsoleParameters;
import org.eclipse.osee.executor.admin.CancellableCallable;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.OrcsPerformance;
import org.eclipse.osee.orcs.core.internal.console.IndexerUtil;
import org.eclipse.osee.orcs.statistics.IndexerStatistics;
import org.eclipse.osee.orcs.statistics.QueryStatistics;

public class PerformanceInfoCommand
implements ConsoleCommand {
    private OrcsApi orcsApi;

    public void setOrcsApi(OrcsApi orcsApi) {
        this.orcsApi = orcsApi;
    }

    public OrcsApi getOrcsApi() {
        return this.orcsApi;
    }

    public String getName() {
        return "performance";
    }

    public String getDescription() {
        return "Displays performance information";
    }

    public String getUsage() {
        return "[statusId=<[QUERY|INDEXER|ALL],..>] [reset=<TRUE|FALSE>]";
    }

    private Collection<StatsType> toStatusTypes(String[] stats) {
        HashSet<StatsType> statsType = new HashSet<StatsType>();
        boolean addAllStatTypes = false;
        if (stats != null && stats.length > 0) {
            String[] stringArray = stats;
            int n = stats.length;
            int n2 = 0;
            while (n2 < n) {
                String stat = stringArray[n2];
                StatsType type = StatsType.valueOf(stat.toUpperCase());
                if (StatsType.ALL == type) {
                    addAllStatTypes = true;
                    break;
                }
                statsType.add(type);
                ++n2;
            }
        } else {
            addAllStatTypes = true;
        }
        if (addAllStatTypes) {
            statsType.addAll(Arrays.asList(StatsType.values()));
        }
        return statsType;
    }

    public Callable<?> createCallable(Console console, ConsoleParameters params) {
        boolean isResetAllowed = params.getBoolean("reset");
        Collection<StatsType> statsType = this.toStatusTypes(params.getArray("statusId"));
        OrcsPerformance performance = this.getOrcsApi().getOrcsPerformance();
        return new PerformanceCallable(console, performance, statsType, isResetAllowed);
    }

    private static final class PerformanceCallable
    extends CancellableCallable<Boolean> {
        private final Console console;
        private final OrcsPerformance performance;
        private final Collection<StatsType> statsType;
        private final boolean isResetAllowed;

        public PerformanceCallable(Console console, OrcsPerformance performance, Collection<StatsType> statsType, boolean isResetAllowed) {
            this.console = console;
            this.performance = performance;
            this.statsType = statsType;
            this.isResetAllowed = isResetAllowed;
        }

        private boolean isResetAllowed(StatsType type) {
            return this.isResetAllowed && this.isWriteAllowed(type);
        }

        private boolean isWriteAllowed(StatsType type) {
            return this.statsType.contains((Object)type);
        }

        public Boolean call() throws Exception {
            if (this.isResetAllowed(StatsType.QUERY)) {
                this.performance.clearQueryStatistics();
            }
            if (this.isWriteAllowed(StatsType.QUERY)) {
                QueryStatistics queryStats = this.performance.getQueryStatistics();
                this.writeStatistics(queryStats);
            }
            if (this.isResetAllowed(StatsType.INDEXER)) {
                this.performance.clearIndexerStatistics();
            }
            if (this.isWriteAllowed(StatsType.INDEXER)) {
                IndexerStatistics indexerStats = this.performance.getIndexerStatistics();
                IndexerUtil.writeStatistics(this.console, indexerStats);
            }
            return Boolean.TRUE;
        }

        private void writeStatistics(QueryStatistics stats) {
            this.console.writeln((Object)"\n----------------------------------------------");
            this.console.writeln((Object)"                  Search Stats");
            this.console.writeln((Object)"----------------------------------------------");
            this.console.writeln("Total Searches - [%d]", new Object[]{stats.getTotalSearches()});
            this.console.writeln("Search Time    - avg: [%s] ms - longest: [%s] ms", new Object[]{stats.getAverageSearchTime(), stats.getLongestSearchTime()});
            this.console.writeln("Longest Search  - %s", new Object[]{stats.getLongestSearch()});
        }
    }

    private static enum StatsType {
        QUERY,
        INDEXER,
        ALL;

    }
}

