/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.console;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.concurrent.Callable;
import org.eclipse.osee.console.admin.Console;
import org.eclipse.osee.console.admin.ConsoleCommand;
import org.eclipse.osee.console.admin.ConsoleParameters;
import org.eclipse.osee.executor.admin.CancellableCallable;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.core.internal.console.IndexStatusDisplayCollector;
import org.eclipse.osee.orcs.core.internal.console.IndexerUtil;
import org.eclipse.osee.orcs.data.BranchReadable;
import org.eclipse.osee.orcs.search.BranchQuery;
import org.eclipse.osee.orcs.search.IndexerCollector;
import org.eclipse.osee.orcs.search.QueryIndexer;
import org.eclipse.osee.orcs.statistics.IndexerStatistics;

public class IndexerCommand
implements ConsoleCommand {
    private OrcsApi orcsApi;

    public void setOrcsApi(OrcsApi orcsApi) {
        this.orcsApi = orcsApi;
    }

    public OrcsApi getOrcsApi() {
        return this.orcsApi;
    }

    public String getName() {
        return "indexer";
    }

    public String getDescription() {
        return "Interacts with the data indexer";
    }

    public String getUsage() {
        StringBuilder builder = new StringBuilder();
        builder.append("op=<");
        OpType[] types = OpType.values();
        int cnt = 0;
        OpType[] opTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            OpType type = opTypeArray[n2];
            if (OpType.ITEM_IDS != type) {
                builder.append((Object)type);
                if (cnt + 1 < types.length) {
                    builder.append("|");
                }
            }
            ++cnt;
            ++n2;
        }
        builder.append("> [branchUuids=<BRANCH_UUID,..>]\n");
        builder.append("op=ITEM_IDS ids=<GAMMA_IDS,..> debug=<TRUE|FALSE>\n");
        builder.append("op=ATTR_TYPE_IDS ids=<ATTR_TYPE_IDS,..>");
        return builder.toString();
    }

    public Callable<?> createCallable(Console console, ConsoleParameters params) {
        return new IndexerCommandCallable(console, params);
    }

    private final class IndexerCommandCallable
    extends CancellableCallable<Boolean> {
        private final Console console;
        private final ConsoleParameters params;

        public IndexerCommandCallable(Console console, ConsoleParameters params) {
            this.console = console;
            this.params = params;
        }

        private OpType toOpType(String value) {
            OpType opType = OpType.STATS;
            if (Strings.isValid((String)value)) {
                opType = OpType.valueOf(value.toUpperCase());
            }
            return opType;
        }

        public Boolean call() throws Exception {
            long startTime = System.currentTimeMillis();
            boolean indexOnlyMissingitems = false;
            HashSet<BranchReadable> branches = new HashSet<BranchReadable>();
            String[] uuids = this.params.getArray("branchUuids");
            if (uuids != null && uuids.length > 0) {
                String[] stringArray = uuids;
                int n = uuids.length;
                int n2 = 0;
                while (n2 < n) {
                    String uuid = stringArray[n2];
                    branches.add((BranchReadable)((BranchQuery)IndexerCommand.this.getOrcsApi().getQueryFactory().branchQuery().andId(BranchId.valueOf((String)uuid))).getResults().getExactlyOne());
                    ++n2;
                }
            }
            QueryIndexer indexer = IndexerCommand.this.getOrcsApi().getQueryIndexer();
            OpType opType = this.toOpType(this.params.get("op"));
            switch (opType) {
                case CANCEL: {
                    throw new UnsupportedOperationException("Can't cancel index op");
                }
                case DROP: {
                    if (branches.isEmpty()) {
                        indexer.purgeAllIndexes().call();
                        break;
                    }
                    throw new UnsupportedOperationException("Can't selectively drop indexed branches");
                }
                case MISSING_ITEMS_ONLY: {
                    indexOnlyMissingitems = true;
                }
                case ALL: {
                    IndexStatusDisplayCollector collector = new IndexStatusDisplayCollector(this.console, startTime, false);
                    CancellableCallable callable = indexer.indexBranches(branches, indexOnlyMissingitems, new IndexerCollector[]{collector});
                    callable.call();
                    break;
                }
                case ITEM_IDS: 
                case ATTR_TYPE_IDS: {
                    boolean printTags = this.params.getBoolean("debug");
                    LinkedHashSet<Long> ids = new LinkedHashSet<Long>();
                    String[] stringArray = this.params.getArray("ids");
                    int n = stringArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        String value = stringArray[n3];
                        ids.add(Long.parseLong(value));
                        ++n3;
                    }
                    if (opType == OpType.ATTR_TYPE_IDS) {
                        indexer.indexAttrTypeIds(ids);
                        break;
                    }
                    IndexStatusDisplayCollector collector2 = new IndexStatusDisplayCollector(this.console, startTime, printTags);
                    Callable callable2 = indexer.indexResources(ids, new IndexerCollector[]{collector2});
                    callable2.call();
                    break;
                }
                default: {
                    IndexerStatistics indexerStats = IndexerCommand.this.getOrcsApi().getOrcsPerformance().getIndexerStatistics();
                    IndexerUtil.writeStatistics(this.console, indexerStats);
                }
            }
            return Boolean.TRUE;
        }
    }

    private static enum OpType {
        STATS,
        DROP,
        ALL,
        MISSING_ITEMS_ONLY,
        ITEM_IDS,
        ATTR_TYPE_IDS,
        CANCEL;

    }
}

