/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.console;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.osee.console.admin.Console;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.orcs.search.IndexerCollectorAdapter;

public final class IndexStatusDisplayCollector
extends IndexerCollectorAdapter {
    private final int DEFAULT_STATS_PRINT_FREQUENCY = 1000;
    private final List<Integer> taskIds = new CopyOnWriteArrayList<Integer>();
    private int attributesProcessed;
    private int queriesProcessed;
    private final long startTime;
    private long totalAttributes;
    private int totalQueries;
    private final boolean printTags;
    private final int statsPrintFrequency;
    private final Console console;

    public IndexStatusDisplayCollector(Console console, long startTime, boolean printTags) {
        this(console, startTime, -1, printTags);
    }

    public IndexStatusDisplayCollector(Console console, long startTime, int statsPrintFrequency, boolean printTags) {
        this.console = console;
        this.startTime = startTime;
        this.attributesProcessed = 0;
        this.queriesProcessed = 0;
        this.statsPrintFrequency = statsPrintFrequency <= 0 ? 1000 : statsPrintFrequency;
        this.printTags = printTags;
    }

    public boolean isProcessingDone() {
        return this.queriesProcessed == this.totalQueries();
    }

    private int totalQueries() {
        int toReturn = this.totalQueries;
        if (toReturn == 0) {
            int remainder = (int)this.totalAttributes % this.statsPrintFrequency;
            toReturn = (int)this.totalAttributes / this.statsPrintFrequency + (remainder > 0 ? 1 : 0);
        }
        return toReturn;
    }

    public void onIndexTaskSubmit(int indexerId) {
        this.taskIds.add(indexerId);
    }

    public void printStats() {
        this.console.writeln("QueryIds: [ %d of %d] Attributes: [%d of %d] - Elapsed Time = %s.", new Object[]{this.queriesProcessed, this.totalQueries(), this.attributesProcessed, this.totalAttributes, Lib.getElapseString((long)this.startTime)});
    }

    public void onIndexTaskTotalToProcess(int totalQueries) {
        this.totalQueries = totalQueries;
    }

    public void onIndexTotalTaskItems(long totalItems) {
        this.totalAttributes = totalItems;
    }

    public void onIndexItemComplete(int queryId, long gammaId, int totalTags, long processingTime) {
        if (this.taskIds.contains(queryId)) {
            ++this.attributesProcessed;
            if (this.attributesProcessed % this.statsPrintFrequency == 0) {
                this.printStats();
            }
        }
    }

    public synchronized void onIndexTaskComplete(int queryId, long waitTime, long processingTime) {
        this.taskIds.remove((Object)queryId);
        ++this.queriesProcessed;
        if (this.taskIds.isEmpty()) {
            this.console.writeln("QueryIds: [ %d of %d] Attributes: [%d of %d] - Elapsed Time = %s.", new Object[]{this.queriesProcessed, this.totalQueries(), this.attributesProcessed, this.totalAttributes, Lib.getElapseString((long)this.startTime)});
        }
        if (this.isProcessingDone()) {
            ((Object)((Object)this)).notify();
        }
    }

    public void onIndexItemAdded(int indexerId, long itemId, String word, long codedTag) {
        if (this.printTags) {
            this.console.writeln("indexerId:[%s] itemId:[%s] word:[%s] tag:[%s]", new Object[]{indexerId, itemId, word, codedTag});
        }
    }
}

