/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.console;

import java.util.concurrent.Callable;
import org.eclipse.osee.console.admin.Console;
import org.eclipse.osee.console.admin.ConsoleCommand;
import org.eclipse.osee.console.admin.ConsoleParameters;
import org.eclipse.osee.executor.admin.CancellableCallable;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.OrcsTypes;

public class CacheUpdateCommand
implements ConsoleCommand {
    private OrcsApi orcsApi;

    public void setOrcsApi(OrcsApi orcsApi) {
        this.orcsApi = orcsApi;
    }

    public OrcsApi getOrcsApi() {
        return this.orcsApi;
    }

    public String getName() {
        return "cache_update";
    }

    public String getDescription() {
        return "Updates server type caches";
    }

    public String getUsage() {
        StringBuilder builder = new StringBuilder();
        builder.append(" - Update server type caches.");
        return builder.toString();
    }

    public Callable<?> createCallable(Console console, ConsoleParameters params) {
        return new CacheUpdateCallable(console);
    }

    private class CacheUpdateCallable
    extends CancellableCallable<Boolean> {
        private final Console console;

        public CacheUpdateCallable(Console console) {
            this.console = console;
        }

        private OrcsTypes getOrcTypes() {
            return CacheUpdateCommand.this.getOrcsApi().getOrcsTypes();
        }

        public Boolean call() throws OseeCoreException {
            OrcsTypes orcsTypes = this.getOrcTypes();
            orcsTypes.invalidateAll();
            this.console.writeln((Object)"Type caches invalidated.");
            return Boolean.TRUE;
        }
    }
}

