/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.console;

import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import org.eclipse.osee.console.admin.Console;
import org.eclipse.osee.console.admin.ConsoleCommand;
import org.eclipse.osee.console.admin.ConsoleParameters;
import org.eclipse.osee.executor.admin.CancellableCallable;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.OrcsBranch;

public class BranchExchangeCheckCommand
implements ConsoleCommand {
    private OrcsApi orcsApi;

    public void setOrcsApi(OrcsApi orcsApi) {
        this.orcsApi = orcsApi;
    }

    public OrcsApi getOrcsApi() {
        return this.orcsApi;
    }

    public String getName() {
        return "branch_check_exchange";
    }

    public String getDescription() {
        return "Checks the integrity of a branch exchange file.";
    }

    public String getUsage() {
        return "uri=<EXCHANGE_FILE_LOCATION> - exchange file location relative to exchange storage path";
    }

    public Callable<?> createCallable(Console console, ConsoleParameters params) {
        List<String> importFiles = Arrays.asList(params.getArray("uri"));
        OrcsBranch orcsBranch = this.getOrcsApi().getBranchOps();
        return new CheckBranchExchangeCallable(console, orcsBranch, importFiles);
    }

    private static class CheckBranchExchangeCallable
    extends CancellableCallable<Boolean> {
        private final Console console;
        private final OrcsBranch orcsBranch;
        private final List<String> importFiles;

        public CheckBranchExchangeCallable(Console console, OrcsBranch orcsBranch, List<String> importFiles) {
            this.console = console;
            this.orcsBranch = orcsBranch;
            this.importFiles = importFiles;
        }

        public Boolean call() throws Exception {
            for (String fileToImport : this.importFiles) {
                this.console.writeln("Checking branch exchange [%]", new Object[]{fileToImport});
                URI uriToCheck = new URI("exchange://" + fileToImport);
                Callable callable = this.orcsBranch.checkBranchExchangeIntegrity(uriToCheck);
                callable.call();
                this.checkForCancelled();
            }
            return Boolean.TRUE;
        }
    }
}

