/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.console;

import java.util.Comparator;
import java.util.HashSet;
import java.util.concurrent.Callable;
import org.eclipse.osee.console.admin.Console;
import org.eclipse.osee.console.admin.ConsoleCommand;
import org.eclipse.osee.console.admin.ConsoleParameters;
import org.eclipse.osee.executor.admin.CancellableCallable;
import org.eclipse.osee.framework.core.enums.BranchState;
import org.eclipse.osee.framework.core.enums.BranchType;
import org.eclipse.osee.framework.core.model.cache.BranchFilter;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.data.BranchReadable;
import org.eclipse.osee.orcs.search.BranchQuery;

public final class BranchCommand
implements ConsoleCommand {
    private OrcsApi orcsApi;

    public void setOrcsApi(OrcsApi orcsApi) {
        this.orcsApi = orcsApi;
    }

    public OrcsApi getOrcsApi() {
        return this.orcsApi;
    }

    public String getName() {
        return "branch";
    }

    public String getDescription() {
        return "Lists all branches";
    }

    public String getUsage() {
        StringBuilder builder = new StringBuilder();
        builder.append("[typeIs=<");
        builder.append(Collections.toString((String)"|", (Object[])BranchType.values()));
        builder.append(">+]");
        builder.append("\n");
        builder.append(" [typeIsNot=<");
        builder.append(Collections.toString((String)"|", (Object[])BranchType.values()));
        builder.append(">+]");
        builder.append("\n");
        builder.append("[stateIs=<");
        builder.append(Collections.toString((String)"|", (Object[])BranchType.values()));
        builder.append(">+]");
        builder.append("\n");
        builder.append(" [stateIsNot=<");
        builder.append(Collections.toString((String)"|", (Object[])BranchType.values()));
        builder.append(">+]");
        builder.append("\n");
        return builder.toString();
    }

    public Callable<?> createCallable(Console console, ConsoleParameters params) {
        return new BranchCallable(console, params);
    }

    private final class BranchCallable
    extends CancellableCallable<Object> {
        private final Console console;
        private final ConsoleParameters params;

        public BranchCallable(Console console, ConsoleParameters params) {
            this.console = console;
            this.params = params;
        }

        private BranchType[] toBranchType(String[] types, boolean alllIfEmpty) {
            BranchType[] toReturn = new BranchType[]{};
            if (types != null && types.length > 0) {
                HashSet<BranchType> data = new HashSet<BranchType>();
                String[] stringArray = types;
                int n = types.length;
                int n2 = 0;
                while (n2 < n) {
                    String type = stringArray[n2];
                    BranchType typeEnum = BranchType.valueOf((String)type.toUpperCase());
                    data.add(typeEnum);
                    ++n2;
                }
                toReturn = data.toArray(new BranchType[data.size()]);
            } else if (alllIfEmpty) {
                toReturn = BranchType.values();
            }
            return toReturn;
        }

        private BranchState[] toBranchState(String[] types, boolean alllIfEmpty) {
            BranchState[] toReturn = new BranchState[]{};
            if (types != null && types.length > 0) {
                HashSet<BranchState> data = new HashSet<BranchState>();
                String[] stringArray = types;
                int n = types.length;
                int n2 = 0;
                while (n2 < n) {
                    String type = stringArray[n2];
                    BranchState typeEnum = BranchState.valueOf((String)type.toUpperCase());
                    data.add(typeEnum);
                    ++n2;
                }
                toReturn = data.toArray(new BranchState[data.size()]);
            } else if (alllIfEmpty) {
                toReturn = BranchState.values();
            }
            return toReturn;
        }

        public Object call() throws Exception {
            BranchType[] isTypes = this.toBranchType(this.params.getArray("typeIs"), true);
            BranchType[] notTypes = this.toBranchType(this.params.getArray("typeIsNot"), false);
            BranchState[] isStates = this.toBranchState(this.params.getArray("stateIs"), true);
            BranchState[] notStates = this.toBranchState(this.params.getArray("stateIsNot"), false);
            BranchFilter filter = new BranchFilter(isTypes);
            filter.setNegatedBranchTypes(notTypes);
            filter.setBranchStates(isStates);
            filter.setNegatedBranchStates(notStates);
            BranchQuery query = BranchCommand.this.orcsApi.getQueryFactory().branchQuery();
            ResultSet branches = ((BranchQuery)((BranchQuery)query.excludeArchived()).andIsOfType(new BranchType[]{BranchType.WORKING})).getResults();
            branches.sort((Comparator)new Comparator<BranchReadable>(){

                @Override
                public int compare(BranchReadable o1, BranchReadable o2) {
                    return 0;
                }
            });
            int count = 0;
            for (BranchReadable aBranch : branches) {
                this.console.writeln("[%s] - id[%s] guid[%s] sTx[%s] bTx[%s] parent[%s] type[%s] state[%s] archive[%s] name[%s]", new Object[]{++count, aBranch.getUuid(), aBranch.getUuid(), aBranch.getName(), aBranch.getBranchType(), aBranch.getBranchState(), aBranch.getArchiveState(), aBranch.getSourceTransaction(), aBranch.getBaseTransaction(), aBranch.getParentBranch()});
            }
            return Boolean.TRUE;
        }
    }
}

