/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.branch.provider;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import org.eclipse.osee.framework.core.model.Branch;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.orcs.core.internal.branch.provider.BranchProvider;

public class MultiBranchProvider
implements BranchProvider {
    private final boolean recursive;
    private final Set<Branch> branches;
    private final Predicate<Branch> filter;

    public MultiBranchProvider(boolean recursive, Set<Branch> branches, Predicate<Branch> filter) {
        this.recursive = recursive;
        this.branches = branches;
        this.filter = filter;
    }

    private Collection<Branch> getChildBranches(Branch branch) throws OseeCoreException {
        HashSet<Branch> children = new HashSet<Branch>();
        branch.getChildBranches(children, true, this.filter);
        if (this.filter.test(branch)) {
            children.add(branch);
        }
        return children;
    }

    @Override
    public Collection<Branch> getBranches() throws OseeCoreException {
        Conditions.checkNotNull(this.branches, (String)"seeds");
        Set<Branch> result = this.branches;
        if (this.recursive) {
            result = new HashSet<Branch>(this.branches);
            for (Branch b : this.branches) {
                result.addAll(this.getChildBranches(b));
            }
        }
        return result;
    }
}

