/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.branch.provider;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Predicate;
import org.eclipse.osee.framework.core.enums.BranchArchivedState;
import org.eclipse.osee.framework.core.enums.BranchState;
import org.eclipse.osee.framework.core.enums.BranchType;
import org.eclipse.osee.framework.core.model.Branch;
import org.eclipse.osee.framework.core.model.cache.BranchCache;
import org.eclipse.osee.framework.core.model.cache.BranchFilter;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.orcs.core.internal.branch.provider.BranchProvider;

public final class DeletedBranchProvider
implements BranchProvider {
    private final BranchCache branchCache;

    public DeletedBranchProvider(BranchCache branchCache) {
        this.branchCache = branchCache;
    }

    @Override
    public Collection<Branch> getBranches() throws OseeCoreException {
        Conditions.checkNotNull((Object)this.branchCache, (String)"branchCache");
        BranchFilter branchFilter = new BranchFilter(BranchArchivedState.ARCHIVED, new BranchType[0]);
        branchFilter.setBranchStates(new BranchState[]{BranchState.DELETED});
        branchFilter.setNegatedBranchTypes(new BranchType[]{BranchType.BASELINE});
        List branches = this.branchCache.getBranches((Predicate)branchFilter);
        LinkedHashSet<Branch> branchesToReturn = new LinkedHashSet<Branch>();
        branchesToReturn.addAll(branches);
        for (Branch branch : branches) {
            branch.getChildBranches(branchesToReturn, true, (Predicate)branchFilter);
        }
        return branchesToReturn;
    }
}

