/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.branch;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.BranchType;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.core.ds.BranchDataStore;
import org.eclipse.osee.orcs.core.internal.branch.AbstractBranchCallable;
import org.eclipse.osee.orcs.core.internal.branch.BranchUtil;
import org.eclipse.osee.orcs.data.BranchReadable;
import org.eclipse.osee.orcs.search.BranchQuery;
import org.eclipse.osee.orcs.search.QueryFactory;

public class PurgeBranchCallable
extends AbstractBranchCallable<List<BranchId>> {
    private final BranchId branchToken;
    private final boolean isRecursive;
    private final QueryFactory queryFactory;

    public PurgeBranchCallable(Log logger, OrcsSession session, BranchDataStore branchStore, BranchId branchToken, boolean isRecursive, QueryFactory queryFactory) {
        super(logger, session, branchStore);
        this.branchToken = branchToken;
        this.isRecursive = isRecursive;
        this.queryFactory = queryFactory;
    }

    @Override
    protected List<BranchId> innerCall() throws Exception {
        Conditions.checkNotNull((Object)this.branchToken, (String)"branchToPurge");
        BranchQuery branchQuery = this.queryFactory.branchQuery();
        branchQuery.andId(this.branchToken);
        if (this.isRecursive) {
            branchQuery.andIsChildOf(this.branchToken);
        }
        ResultSet branches = branchQuery.getResults();
        LinkedList<BranchId> purged = new LinkedList<BranchId>();
        List<BranchReadable> orderedBranches = BranchUtil.orderByParentReadable((Iterable<? extends BranchReadable>)branches);
        for (BranchReadable aBranch : orderedBranches) {
            this.checkForCancelled();
            this.checkForChildBranches(aBranch);
            Callable<Void> callable = this.getBranchStore().purgeBranch(this.getSession(), aBranch);
            this.callAndCheckForCancel(callable);
            purged.add((BranchId)aBranch);
        }
        return purged;
    }

    private void checkForChildBranches(BranchReadable aBranch) {
        BranchQuery branchQuery = this.queryFactory.branchQuery();
        branchQuery.andIsChildOf((BranchId)aBranch);
        for (BranchReadable child : branchQuery.getResults()) {
            if (child.getBranchType() == BranchType.MERGE) continue;
            throw new OseeArgumentException("Unable to purge a branch containing children: branchUuid[%s] branchType[%s]", new Object[]{aBranch, aBranch.getBranchType()});
        }
    }
}

