/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.branch;

import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.core.ds.BranchDataStore;
import org.eclipse.osee.orcs.core.internal.branch.AbstractBranchCallable;
import org.eclipse.osee.orcs.data.BranchReadable;
import org.eclipse.osee.orcs.data.CreateBranchData;
import org.eclipse.osee.orcs.search.BranchQuery;
import org.eclipse.osee.orcs.search.QueryFactory;
import org.eclipse.osee.orcs.search.TransactionQuery;

public class CreateBranchCallable
extends AbstractBranchCallable<BranchReadable> {
    private final CreateBranchData branchData;
    private final QueryFactory queryFactory;

    public CreateBranchCallable(Log logger, OrcsSession session, BranchDataStore branchStore, CreateBranchData branchData, QueryFactory queryFactory) {
        super(logger, session, branchStore);
        this.branchData = branchData;
        this.queryFactory = queryFactory;
    }

    @Override
    protected BranchReadable innerCall() throws Exception {
        Conditions.checkNotNull((Object)this.branchData, (String)"branchData");
        Conditions.checkNotNull((Object)this.branchData.getBranch(), (String)"branchUuid");
        Conditions.checkNotNull((Object)this.branchData.getName(), (String)"branchName");
        Conditions.checkNotNull((Object)this.branchData.getBranchType(), (String)"branchType");
        TransactionId txData = this.branchData.getFromTransaction();
        Conditions.checkNotNull((Object)txData, (String)"sourceTransaction");
        if (this.branchData.isTxCopyBranchType()) {
            TransactionQuery txQuery = this.queryFactory.transactionQuery();
            TransactionId givenTx = this.branchData.getFromTransaction();
            Conditions.checkNotNull((Object)givenTx, (String)"Transaction used for copy");
            this.branchData.setSavedTransaction(givenTx);
            TransactionId priorTx = (TransactionId)((TransactionQuery)txQuery.andIsPriorTx(givenTx)).getResults().getExactlyOne();
            this.branchData.setFromTransaction(priorTx);
            this.getBranchStore().createBranchCopyTx(this.branchData);
        } else {
            this.getBranchStore().createBranch(this.branchData);
        }
        return (BranchReadable)((BranchQuery)this.queryFactory.branchQuery().andId(this.branchData.getBranch())).getResults().getExactlyOne();
    }
}

