/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.branch;

import java.util.List;
import java.util.concurrent.Callable;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.model.change.ChangeItem;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.core.ds.BranchDataStore;
import org.eclipse.osee.orcs.core.internal.branch.AbstractBranchCallable;
import org.eclipse.osee.orcs.search.ApplicabilityQuery;

public class CompareBranchCallable
extends AbstractBranchCallable<List<ChangeItem>> {
    private final TransactionToken sourceTx;
    private final TransactionToken destinationTx;
    private final ApplicabilityQuery applicQuery;

    public CompareBranchCallable(Log logger, OrcsSession session, BranchDataStore branchStore, TransactionToken sourceTx, TransactionToken destinationTx, ApplicabilityQuery applicQuery) {
        super(logger, session, branchStore);
        this.sourceTx = sourceTx;
        this.destinationTx = destinationTx;
        this.applicQuery = applicQuery;
    }

    @Override
    protected List<ChangeItem> innerCall() throws Exception {
        Conditions.checkNotNull((Object)this.sourceTx, (String)"sourceTx");
        Conditions.checkNotNull((Object)this.destinationTx, (String)"destinationTx");
        Callable<List<ChangeItem>> callable = this.getBranchStore().compareBranch(this.getSession(), this.sourceTx, this.destinationTx, this.applicQuery);
        return this.callAndCheckForCancel(callable);
    }
}

