/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.branch;

import java.util.concurrent.Callable;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.core.ds.BranchDataStore;
import org.eclipse.osee.orcs.core.internal.branch.AbstractBranchCallable;
import org.eclipse.osee.orcs.data.BranchReadable;
import org.eclipse.osee.orcs.search.BranchQuery;
import org.eclipse.osee.orcs.search.QueryFactory;
import org.eclipse.osee.orcs.search.TransactionQuery;

public class CommitBranchCallable
extends AbstractBranchCallable<TransactionToken> {
    private final ArtifactId committer;
    private final BranchId source;
    private final BranchId destination;
    private final QueryFactory queryFactory;

    public CommitBranchCallable(Log logger, OrcsSession session, BranchDataStore branchStore, QueryFactory queryFactory, ArtifactId committer, BranchId source, BranchId destination) {
        super(logger, session, branchStore);
        this.committer = committer;
        this.source = source;
        this.destination = destination;
        this.queryFactory = queryFactory;
    }

    @Override
    protected TransactionToken innerCall() throws Exception {
        Conditions.checkNotNull((Object)this.source, (String)"sourceBranch");
        Conditions.checkNotNull((Object)this.destination, (String)"destinationBranch");
        BranchReadable sourceBranch = (BranchReadable)((BranchQuery)this.queryFactory.branchQuery().andId(this.source)).getResults().getExactlyOne();
        TransactionToken sourceHead = (TransactionToken)((TransactionQuery)this.queryFactory.transactionQuery().andIsHead(this.source)).getResults().getExactlyOne();
        BranchReadable destinationBranch = (BranchReadable)((BranchQuery)this.queryFactory.branchQuery().andId(this.destination)).getResults().getExactlyOne();
        TransactionToken destinationHead = (TransactionToken)((TransactionQuery)this.queryFactory.transactionQuery().andIsHead(this.destination)).getResults().getExactlyOne();
        Conditions.checkNotNull((Object)sourceBranch, (String)"sourceBranch");
        Conditions.checkNotNull((Object)destinationBranch, (String)"destinationBranch");
        Callable<TransactionId> commitBranchCallable = this.getBranchStore().commitBranch(this.getSession(), this.committer, sourceBranch, sourceHead, destinationBranch, destinationHead, this.queryFactory.applicabilityQuery());
        TransactionId newTx = this.callAndCheckForCancel(commitBranchCallable);
        return (TransactionToken)((TransactionQuery)this.queryFactory.transactionQuery().andTxId(newTx)).getResults().getExactlyOne();
    }
}

