/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.branch;

import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.IOseeBranch;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.enums.BranchType;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.orcs.data.CreateBranchData;
import org.eclipse.osee.orcs.search.BranchQuery;
import org.eclipse.osee.orcs.search.QueryFactory;
import org.eclipse.osee.orcs.search.TransactionQuery;

public class BranchDataFactory {
    private final QueryFactory queryFactory;

    public BranchDataFactory(QueryFactory queryFactory) {
        this.queryFactory = queryFactory;
    }

    public CreateBranchData createTopLevelBranchData(IOseeBranch branch, ArtifactId author) {
        return this.createBranchData(branch, author, CoreBranches.SYSTEM_ROOT, ArtifactId.SENTINEL, BranchType.BASELINE);
    }

    public CreateBranchData createBaselineBranchData(IOseeBranch branch, ArtifactId author, IOseeBranch parent, ArtifactId associatedArtifact) {
        return this.createBranchData(branch, author, parent, associatedArtifact, BranchType.BASELINE);
    }

    public CreateBranchData createWorkingBranchData(IOseeBranch branch, ArtifactId author, IOseeBranch parent, ArtifactId associatedArtifact) {
        return this.createBranchData(branch, author, parent, associatedArtifact, BranchType.WORKING);
    }

    private CreateBranchData createBranchData(IOseeBranch branch, ArtifactId author, IOseeBranch parent, ArtifactId associatedArtifact, BranchType branchType) {
        TransactionQuery txQuery = this.queryFactory.transactionQuery();
        TransactionId fromTx = (TransactionId)((TransactionQuery)txQuery.andIsHead((BranchId)parent)).getTokens().getExactlyOne();
        String creationComment = String.format("New Branch from %s (%s)", parent.getName(), fromTx);
        return this.createBranchData(branch, (BranchId)parent, branchType, creationComment, fromTx, author, associatedArtifact, false);
    }

    public CreateBranchData createCopyTxBranchData(IOseeBranch branch, ArtifactId author, TransactionId fromTransaction, ArtifactId associatedArtifact) throws OseeCoreException {
        return this.createBranchData(branch, author, fromTransaction, associatedArtifact, BranchType.WORKING, "copied");
    }

    public CreateBranchData createPortBranchData(IOseeBranch branch, ArtifactId author, TransactionId fromTransaction, ArtifactId associatedArtifact) throws OseeCoreException {
        return this.createBranchData(branch, author, fromTransaction, associatedArtifact, BranchType.PORT, "ported");
    }

    private CreateBranchData createBranchData(IOseeBranch branch, ArtifactId author, TransactionId fromTransaction, ArtifactId associatedArtifact, BranchType branchType, String verb) {
        TransactionQuery txQuery = this.queryFactory.transactionQuery();
        BranchQuery branchQuery = this.queryFactory.branchQuery();
        TransactionToken fromTx = (TransactionToken)((TransactionQuery)txQuery.andTxId(fromTransaction)).getTokens().getExactlyOne();
        IOseeBranch parent = (IOseeBranch)((BranchQuery)branchQuery.andId(fromTx.getBranch())).getResults().getExactlyOne();
        String creationComment = String.format("Transaction %d %s from %s to create Branch %s", fromTransaction.getId(), verb, parent.getName(), branch.getName());
        return this.createBranchData(branch, (BranchId)parent, branchType, creationComment, (TransactionId)fromTx, author, associatedArtifact, true);
    }

    private CreateBranchData createBranchData(IOseeBranch branch, BranchId parent, BranchType branchType, String creationComment, TransactionId sysRootHeadTx, ArtifactId author, ArtifactId associatedArtifact, boolean bCopyTx) {
        CreateBranchData createData = new CreateBranchData((BranchId)branch);
        createData.setName(branch.getName());
        createData.setBranchType(branchType);
        createData.setCreationComment(creationComment);
        createData.setFromTransaction(sysRootHeadTx);
        createData.setAuthor(author);
        createData.setAssociatedArtifact(associatedArtifact);
        createData.setTxCopyBranchType(bCopyTx);
        createData.setParentBranch(parent);
        return createData;
    }
}

