/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.attribute.primitives;

import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.orcs.core.annotations.OseeAttribute;
import org.eclipse.osee.orcs.core.internal.attribute.primitives.CharacterBackedAttribute;

@OseeAttribute(value="IntegerAttribute")
public class IntegerAttribute
extends CharacterBackedAttribute<Integer> {
    private static final Integer DEFAULT_INTEGER = Integer.MIN_VALUE;

    @Override
    public Integer getValue() throws OseeCoreException {
        return (Integer)this.getDataProxy().getValue();
    }

    @Override
    public boolean subClassSetValue(Integer value) throws OseeCoreException {
        if (value == null) {
            throw new OseeArgumentException("Attribute value was null", new Object[0]);
        }
        return this.getDataProxy().setValue(value);
    }

    @Override
    protected Integer convertStringToValue(String value) throws OseeCoreException {
        Integer toReturn = null;
        toReturn = this.isValidInteger(value) ? Integer.valueOf(value) : this.getDefaultValue();
        return toReturn;
    }

    public Integer getDefaultValue() throws OseeCoreException {
        Integer toReturn = DEFAULT_INTEGER;
        String defaultValue = this.getDefaultValueFromMetaData();
        if (this.isValidInteger(defaultValue)) {
            toReturn = Integer.valueOf(defaultValue);
        }
        return toReturn;
    }

    private boolean isValidInteger(String value) {
        boolean result = false;
        if (Strings.isValid((String)value)) {
            try {
                Integer.parseInt(value);
                result = true;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return result;
    }
}

