/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.attribute.primitives;

import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.orcs.core.annotations.OseeAttribute;
import org.eclipse.osee.orcs.core.internal.attribute.primitives.CharacterBackedAttribute;

@OseeAttribute(value="FloatingPointAttribute")
public class FloatingPointAttribute
extends CharacterBackedAttribute<Double> {
    private static final Double DEFAULT_DOUBLE = Double.MIN_VALUE;

    @Override
    public Double getValue() throws OseeCoreException {
        return (Double)this.getDataProxy().getValue();
    }

    @Override
    public boolean subClassSetValue(Double value) throws OseeCoreException {
        if (value == null) {
            throw new OseeArgumentException("Attribute value was null", new Object[0]);
        }
        return this.getDataProxy().setValue(value);
    }

    @Override
    protected Double convertStringToValue(String value) throws OseeCoreException {
        Double toReturn = null;
        toReturn = this.isValidDouble(value) ? Double.valueOf(value) : this.getDefaultValue();
        return toReturn;
    }

    public Double getDefaultValue() throws OseeCoreException {
        Double toReturn = DEFAULT_DOUBLE;
        String defaultValue = this.getDefaultValueFromMetaData();
        if (this.isValidDouble(defaultValue)) {
            toReturn = Double.valueOf(defaultValue);
        }
        return toReturn;
    }

    private boolean isValidDouble(String value) {
        boolean result = false;
        if (Strings.isValid((String)value)) {
            try {
                Double.parseDouble(value);
                result = true;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return result;
    }
}

