/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.attribute.primitives;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.orcs.core.annotations.OseeAttribute;
import org.eclipse.osee.orcs.core.internal.attribute.primitives.CharacterBackedAttribute;

@OseeAttribute(value="DateAttribute")
public class DateAttribute
extends CharacterBackedAttribute<Date> {
    private static final DateFormat MMDDYYHHMM = new SimpleDateFormat("MM/dd/yyyy hh:mm a");

    @Override
    public Date getValue() throws OseeCoreException {
        Object value = this.getDataProxy().getValue();
        return new Date((Long)value);
    }

    @Override
    protected void setToDefaultValue() throws OseeCoreException {
        String defaultValue = this.getDefaultValueFromMetaData();
        if (Strings.isValid((String)defaultValue)) {
            this.subClassSetValue(this.convertStringToValue(defaultValue));
        } else {
            this.subClassSetValue(new Date());
        }
    }

    @Override
    public boolean subClassSetValue(Date value) throws OseeCoreException {
        return this.getDataProxy().setValue(value != null ? Long.valueOf(value.getTime()) : "");
    }

    @Override
    public String getDisplayableString() throws OseeCoreException {
        return this.getAsFormattedString(MMDDYYHHMM);
    }

    @Override
    protected Date convertStringToValue(String value) {
        if (!Strings.isValid((String)value)) {
            return null;
        }
        return new Date(Long.parseLong(value));
    }

    public String getAsFormattedString(DateFormat dateFormat) throws OseeCoreException {
        Date date = this.getValue();
        return date != null ? dateFormat.format(date) : "";
    }
}

