/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.attribute.primitives;

import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.Reference;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.ModificationType;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.core.ds.AttributeData;
import org.eclipse.osee.orcs.core.ds.DataProxy;
import org.eclipse.osee.orcs.core.internal.attribute.Attribute;
import org.eclipse.osee.orcs.core.internal.attribute.AttributeContainer;
import org.eclipse.osee.orcs.data.AttributeTypes;

public abstract class AttributeImpl<T>
implements Comparable<AttributeImpl<T>>,
Attribute<T> {
    private AttributeTypes attributeTypeCache;
    private Reference<AttributeContainer> containerReference;
    private String defaultValue;
    private Log logger;
    private AttributeData attributeData;

    @Override
    public void internalInitialize(AttributeTypes attributeTypeCache, Reference<AttributeContainer> containerReference, AttributeData attributeData, boolean isDirty, boolean setDefaultValue) throws OseeCoreException {
        this.attributeTypeCache = attributeTypeCache;
        this.containerReference = containerReference;
        this.attributeData = attributeData;
        if (setDefaultValue) {
            this.setToDefaultValue();
        }
        this.getOrcsData().calculateDirtyState(isDirty);
        this.uponInitialize();
    }

    protected Log getLogger() {
        return this.logger;
    }

    @Override
    public AttributeData getOrcsData() {
        return this.attributeData;
    }

    @Override
    public void setOrcsData(AttributeData data) {
        this.attributeData = data;
    }

    protected void uponInitialize() throws OseeCoreException {
    }

    private void markAsNewOrChanged() {
        if (this.isInDb()) {
            this.markAsChanged(ModificationType.MODIFIED);
        } else {
            this.markAsChanged(ModificationType.NEW);
        }
    }

    @Override
    public void setValue(T value) throws OseeCoreException {
        if (this.subClassSetValue(value)) {
            this.markAsNewOrChanged();
        }
    }

    @Override
    public boolean setFromString(String value) throws OseeCoreException {
        boolean response = this.subClassSetValue(this.convertStringToValue(value));
        if (response) {
            this.markAsNewOrChanged();
        }
        return response;
    }

    protected abstract T convertStringToValue(String var1) throws OseeCoreException;

    @Override
    public final void resetToDefaultValue() throws OseeCoreException {
        this.getOrcsData().setModType(ModificationType.MODIFIED);
        this.setToDefaultValue();
    }

    protected void setToDefaultValue() throws OseeCoreException {
        if (this.defaultValue != null) {
            this.subClassSetValue(this.convertStringToValue(this.defaultValue));
        }
    }

    @Override
    public boolean setValueFromInputStream(InputStream value) throws OseeCoreException {
        boolean success = false;
        try {
            success = this.setFromString(Lib.inputStreamToString((InputStream)value));
            if (success) {
                this.markAsNewOrChanged();
            }
        }
        catch (IOException ex) {
            OseeCoreException.wrapAndThrow((Throwable)ex);
        }
        return success;
    }

    protected abstract boolean subClassSetValue(T var1) throws OseeCoreException;

    public abstract T getValue() throws OseeCoreException;

    public String getDisplayableString() throws OseeCoreException {
        return this.getDataProxy().getDisplayableString();
    }

    public String toString() {
        try {
            return this.getDisplayableString();
        }
        catch (OseeCoreException ex) {
            return Lib.exceptionToString((Exception)((Object)ex));
        }
    }

    public DataProxy getDataProxy() {
        return this.getOrcsData().getDataProxy();
    }

    public boolean isDirty() {
        return this.getOrcsData().isDirty();
    }

    protected void markAsChanged(ModificationType modificationType) {
        this.setDirtyFlag(true);
        this.getOrcsData().setModType(modificationType);
    }

    @Override
    public void clearDirty() {
        this.setDirtyFlag(false);
    }

    private void setDirtyFlag(boolean dirty) {
        this.getOrcsData().calculateDirtyState(dirty);
    }

    public AttributeContainer getContainer() throws OseeStateException {
        if (this.containerReference.get() == null) {
            throw new OseeStateException("Attribute parent has been garbage collected", new Object[0]);
        }
        return this.containerReference.get();
    }

    protected String getDefaultValueFromMetaData() throws OseeCoreException {
        return this.attributeTypeCache.getDefaultValue((AttributeTypeId)this.getAttributeType());
    }

    public AttributeTypeToken getAttributeType() throws OseeCoreException {
        return (AttributeTypeToken)this.attributeTypeCache.get(Long.valueOf(this.getOrcsData().getTypeUuid()));
    }

    public boolean isOfType(AttributeTypeId otherAttributeType) throws OseeCoreException {
        return this.getAttributeType().equals(otherAttributeType);
    }

    public void unDelete() {
        this.getOrcsData().setModType(this.getOrcsData().getPreviousModType());
    }

    @Override
    public final void setArtifactDeleted() {
        this.markAsChanged(ModificationType.ARTIFACT_DELETED);
    }

    public final void delete() throws OseeCoreException {
        if (this.isInDb()) {
            this.markAsChanged(ModificationType.DELETED);
        } else {
            this.getContainer().remove((AttributeTypeId)this.getAttributeType(), this);
        }
    }

    public ModificationType getModificationType() {
        return this.getOrcsData().getModType();
    }

    public boolean isDeleteAllowed() {
        try {
            return !this.isDeleted() && this.getContainer().getAttributeCount((AttributeTypeId)this.getAttributeType()) > this.attributeTypeCache.getMinOccurrences((AttributeTypeId)this.getAttributeType());
        }
        catch (OseeCoreException oseeCoreException) {
            return false;
        }
    }

    public void purge() throws OseeCoreException {
        this.getDataProxy().purge();
    }

    public void markAsPurged() {
        this.getOrcsData().setModType(ModificationType.DELETED);
        this.setDirtyFlag(false);
    }

    public boolean isInDb() {
        return this.getGammaId() > 0L;
    }

    public Integer getLocalId() {
        return this.getOrcsData().getLocalId();
    }

    public long getGammaId() {
        return this.getOrcsData().getVersion().getGammaId();
    }

    public void internalSetGammaId(int gammaId) {
        this.getOrcsData().getVersion().setGammaId(gammaId);
    }

    public void internalSetAttributeId(int attrId) {
        this.getOrcsData().setLocalId(attrId);
    }

    public void replaceWithVersion(int gammaId) throws OseeCoreException {
        this.internalSetModificationType(ModificationType.REPLACED_WITH_VERSION);
        this.getOrcsData().getVersion().setGammaId(gammaId);
        this.setDirtyFlag(true);
    }

    public void internalSetModificationType(ModificationType modificationType) throws OseeCoreException {
        Conditions.checkNotNull((Object)modificationType, (String)"modification type");
        this.getOrcsData().setModType(modificationType);
    }

    public void internalSetDeletedFromRemoteEvent() throws OseeCoreException {
        this.internalSetModificationType(ModificationType.DELETED);
    }

    @Override
    public int compareTo(AttributeImpl<T> other) {
        return this.toString().compareTo(other.toString());
    }

    public Long getId() {
        return this.getOrcsData().getId();
    }
}

