/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.attribute;

import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.enums.DeletionFlag;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.orcs.core.internal.attribute.Attribute;
import org.eclipse.osee.orcs.core.internal.attribute.AttributeCollection;
import org.eclipse.osee.orcs.core.internal.attribute.AttributeManager;
import org.eclipse.osee.orcs.core.internal.attribute.AttributeSetHelper;

public class TypedValueAttributeSetHelper<T>
implements AttributeSetHelper<T, T> {
    private final AttributeCollection attributes;
    private final AttributeManager manager;

    public TypedValueAttributeSetHelper(AttributeCollection attributes, AttributeManager manager) {
        this.attributes = attributes;
        this.manager = manager;
    }

    @Override
    public boolean matches(Attribute<T> attribute, T value) throws OseeCoreException {
        return value.equals(attribute.getValue());
    }

    @Override
    public void setAttributeValue(Attribute<T> attribute, T value) throws OseeCoreException {
        attribute.setValue(value);
    }

    @Override
    public void createAttribute(AttributeTypeId attributeType, T value) throws OseeCoreException {
        ResultSet<Attribute<T>> result = this.attributes.getAttributeSetFromValue(attributeType, DeletionFlag.EXCLUDE_DELETED, value);
        if (result.getOneOrNull() == null) {
            this.manager.createAttribute(attributeType, value);
        }
    }
}

