/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.attribute;

import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.enums.DeletionFlag;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.orcs.core.internal.attribute.Attribute;
import org.eclipse.osee.orcs.core.internal.attribute.AttributeCollection;
import org.eclipse.osee.orcs.core.internal.attribute.AttributeManager;
import org.eclipse.osee.orcs.core.internal.attribute.AttributeSetHelper;

public class FromStringAttributeSetHelper
implements AttributeSetHelper<Object, String> {
    private final AttributeCollection attributes;
    private final AttributeManager manager;

    public FromStringAttributeSetHelper(AttributeCollection attributes, AttributeManager manager) {
        this.attributes = attributes;
        this.manager = manager;
    }

    private String asString(Object object) {
        return String.valueOf(object);
    }

    @Override
    public boolean matches(Attribute<Object> attribute, String value) throws OseeCoreException {
        Object attrValue = attribute.getValue();
        return value.equals(this.asString(attrValue));
    }

    @Override
    public void setAttributeValue(Attribute<Object> attribute, String value) throws OseeCoreException {
        attribute.setFromString(value);
    }

    @Override
    public void createAttribute(AttributeTypeId attributeType, String value) throws OseeCoreException {
        ResultSet result = this.attributes.getAttributeSetFromString(attributeType, DeletionFlag.EXCLUDE_DELETED, value);
        if (result.getOneOrNull() == null) {
            this.manager.createAttributeFromString(attributeType, value);
        }
    }
}

